/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action.internal;

import java.nio.file.Path;
import java.util.Map;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.CompressActionFactory;
import org.apache.logging.log4j.core.appender.rolling.action.CompressActionFactoryProvider;
import org.apache.logging.log4j.core.appender.rolling.action.internal.GzCompressAction;
import org.apache.logging.log4j.core.appender.rolling.action.internal.ZipCompressAction;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Ordered;
import org.apache.logging.log4j.plugins.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@Plugin
@Namespace(value="compress")
@Ordered(value=0x7FFFFFFF)
@NullMarked
public class JreCompressActionFactoryProvider
implements CompressActionFactoryProvider {
    @Override
    public @Nullable CompressActionFactory createFactoryForAlgorithm(String extension) {
        return switch (extension) {
            case "gz" -> new GzCompressActionFactory();
            case "zip" -> new ZipCompressActionFactory();
            default -> null;
        };
    }

    private static final class GzCompressActionFactory
    implements CompressActionFactory {
        static final String NAME = "gz";

        private GzCompressActionFactory() {
        }

        @Override
        public Action createCompressAction(Path source, Path destination, Map<String, String> options) {
            return new GzCompressAction(source, destination, -1);
        }

        @Override
        public String getAlgorithmName() {
            return NAME;
        }
    }

    private static final class ZipCompressActionFactory
    implements CompressActionFactory {
        static final String NAME = "zip";

        private ZipCompressActionFactory() {
        }

        @Override
        public Action createCompressAction(Path source, Path destination, Map<String, String> options) {
            return new ZipCompressAction(source, destination, -1);
        }

        @Override
        public String getAlgorithmName() {
            return NAME;
        }
    }
}

