/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.transport;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedInteger;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.UnsignedShort;
import org.apache.qpid.protonj2.types.transport.Performative;

public final class Begin
implements Performative {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(17L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:begin:list");
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final int REMOTE_CHANNEL = 1;
    private static final int NEXT_OUTGOING_ID = 2;
    private static final int INCOMING_WINDOW = 4;
    private static final int OUTGOING_WINDOW = 8;
    private static final int HANDLE_MAX = 16;
    private static final int OFFERED_CAPABILITIES = 32;
    private static final int DESIRED_CAPABILITIES = 64;
    private static final int PROPERTIES = 128;
    private int modified = 0;
    private int remoteChannel;
    private long nextOutgoingId;
    private long incomingWindow;
    private long outgoingWindow;
    private long handleMax = UnsignedInteger.MAX_VALUE.longValue();
    private Symbol[] offeredCapabilities;
    private Symbol[] desiredCapabilities;
    private Map<Symbol, Object> properties;

    @Override
    public Performative.PerformativeType getPerformativeType() {
        return Performative.PerformativeType.BEGIN;
    }

    @Override
    public Begin copy() {
        Begin copy = new Begin();
        copy.remoteChannel = this.remoteChannel;
        copy.nextOutgoingId = this.nextOutgoingId;
        copy.incomingWindow = this.incomingWindow;
        copy.outgoingWindow = this.outgoingWindow;
        copy.handleMax = this.handleMax;
        if (this.offeredCapabilities != null) {
            copy.offeredCapabilities = Arrays.copyOf(this.offeredCapabilities, this.offeredCapabilities.length);
        }
        if (this.desiredCapabilities != null) {
            copy.desiredCapabilities = Arrays.copyOf(this.desiredCapabilities, this.desiredCapabilities.length);
        }
        if (this.properties != null) {
            copy.properties = new LinkedHashMap<Symbol, Object>(this.properties);
        }
        copy.modified = this.modified;
        return copy;
    }

    public boolean isEmpty() {
        return this.modified == 0;
    }

    public int getElementCount() {
        return 32 - Integer.numberOfLeadingZeros(this.modified);
    }

    public boolean hasElement(int index) {
        int value = 1 << index;
        return (this.modified & value) == value;
    }

    public boolean hasRemoteChannel() {
        return (this.modified & 1) == 1;
    }

    public boolean hasNextOutgoingId() {
        return (this.modified & 2) == 2;
    }

    public boolean hasIncomingWindow() {
        return (this.modified & 4) == 4;
    }

    public boolean hasOutgoingWindow() {
        return (this.modified & 8) == 8;
    }

    public boolean hasHandleMax() {
        return (this.modified & 0x10) == 16;
    }

    public boolean hasOfferedCapabilities() {
        return (this.modified & 0x20) == 32;
    }

    public boolean hasDesiredCapabilities() {
        return (this.modified & 0x40) == 64;
    }

    public boolean hasProperties() {
        return (this.modified & 0x80) == 128;
    }

    public int getRemoteChannel() {
        return this.remoteChannel;
    }

    public Begin setRemoteChannel(int remoteChannel) {
        if (remoteChannel < 0 || remoteChannel > UnsignedShort.MAX_VALUE.intValue()) {
            throw new IllegalArgumentException("Remote channel value given is out of range: " + remoteChannel);
        }
        this.modified |= 1;
        this.remoteChannel = remoteChannel;
        return this;
    }

    public long getNextOutgoingId() {
        return this.nextOutgoingId;
    }

    public Begin setNextOutgoingId(int nextOutgoingId) {
        this.modified |= 2;
        this.nextOutgoingId = Integer.toUnsignedLong(nextOutgoingId);
        return this;
    }

    public Begin setNextOutgoingId(long nextOutgoingId) {
        if (nextOutgoingId < 0L || nextOutgoingId > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Next Outgoing Id value given is out of range: " + nextOutgoingId);
        }
        this.modified |= 2;
        this.nextOutgoingId = nextOutgoingId;
        return this;
    }

    public long getIncomingWindow() {
        return this.incomingWindow;
    }

    public Begin setIncomingWindow(int incomingWindow) {
        this.modified |= 4;
        this.incomingWindow = Integer.toUnsignedLong(incomingWindow);
        return this;
    }

    public Begin setIncomingWindow(long incomingWindow) {
        if (incomingWindow < 0L || incomingWindow > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Incoming Window value given is out of range: " + incomingWindow);
        }
        this.modified |= 4;
        this.incomingWindow = incomingWindow;
        return this;
    }

    public long getOutgoingWindow() {
        return this.outgoingWindow;
    }

    public Begin setOutgoingWindow(int outgoingWindow) {
        this.modified |= 8;
        this.outgoingWindow = Integer.toUnsignedLong(outgoingWindow);
        return this;
    }

    public Begin setOutgoingWindow(long outgoingWindow) {
        if (outgoingWindow < 0L || outgoingWindow > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Incoming Window value given is out of range: " + outgoingWindow);
        }
        this.modified |= 8;
        this.outgoingWindow = outgoingWindow;
        return this;
    }

    public long getHandleMax() {
        return this.handleMax;
    }

    public Begin setHandleMax(int handleMax) {
        this.modified |= 0x10;
        this.handleMax = Integer.toUnsignedLong(handleMax);
        return this;
    }

    public Begin setHandleMax(long handleMax) {
        if (handleMax < 0L || handleMax > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Handle Max value given is out of range: " + handleMax);
        }
        this.modified |= 0x10;
        this.handleMax = handleMax;
        return this;
    }

    public Symbol[] getOfferedCapabilities() {
        return this.offeredCapabilities;
    }

    public Begin setOfferedCapabilities(Symbol ... offeredCapabilities) {
        this.modified = offeredCapabilities != null ? (this.modified |= 0x20) : (this.modified &= 0xFFFFFFDF);
        this.offeredCapabilities = offeredCapabilities;
        return this;
    }

    public Symbol[] getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public Begin setDesiredCapabilities(Symbol ... desiredCapabilities) {
        this.modified = desiredCapabilities != null ? (this.modified |= 0x40) : (this.modified &= 0xFFFFFFBF);
        this.desiredCapabilities = desiredCapabilities;
        return this;
    }

    public Map<Symbol, Object> getProperties() {
        return this.properties;
    }

    public Begin setProperties(Map<Symbol, Object> properties) {
        this.modified = properties != null ? (this.modified |= 0x80) : (this.modified &= 0xFFFFFF7F);
        this.properties = properties;
        return this;
    }

    @Override
    public <E> void invoke(Performative.PerformativeHandler<E> handler, ProtonBuffer payload, int channel, E context) {
        handler.handleBegin(this, payload, channel, context);
    }

    public String toString() {
        return "Begin{remoteChannel=" + String.valueOf(this.hasRemoteChannel() ? Integer.valueOf(this.remoteChannel) : "null") + ", nextOutgoingId=" + String.valueOf(this.hasNextOutgoingId() ? Long.valueOf(this.nextOutgoingId) : "null") + ", incomingWindow=" + String.valueOf(this.hasIncomingWindow() ? Long.valueOf(this.incomingWindow) : "null") + ", outgoingWindow=" + String.valueOf(this.hasOutgoingWindow() ? Long.valueOf(this.outgoingWindow) : "null") + ", handleMax=" + String.valueOf(this.hasHandleMax() ? Long.valueOf(this.handleMax) : "null") + ", offeredCapabilities=" + String.valueOf(this.offeredCapabilities == null ? "null" : Arrays.asList(this.offeredCapabilities)) + ", desiredCapabilities=" + String.valueOf(this.desiredCapabilities == null ? "null" : Arrays.asList(this.desiredCapabilities)) + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

