/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

public class CpuMeter {
    private OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private final Id allCpuUsage;
    private final Id processCpuUsage;

    public CpuMeter(Id id) {
        this.allCpuUsage = id.withTag("type", "cpu");
        this.processCpuUsage = id.withTag("type", "processCpu");
    }

    public void calcMeasurements(List<Measurement> measurements, long msNow) {
        measurements.add(new Measurement(this.allCpuUsage, msNow, this.osBean.getSystemCpuLoad()));
        measurements.add(new Measurement(this.processCpuUsage, msNow, this.osBean.getProcessCpuLoad()));
    }

    @VisibleForTesting
    public void setOsBean(OperatingSystemMXBean bean) {
        this.osBean = bean;
    }
}

