/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.stream;

import io.vertx.core.buffer.Buffer;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class BufferOutputStream
extends OutputStream {
    private static final int DIRECT_BUFFER_SIZE = 1024;
    protected Buffer byteBuf;

    public BufferOutputStream() {
        this(Buffer.buffer((int)1024));
    }

    public BufferOutputStream(Buffer buffer) {
        this.byteBuf = buffer;
    }

    public Buffer getBuffer() {
        return this.byteBuf;
    }

    public int length() {
        return this.byteBuf.length();
    }

    public void writeByte(byte value) {
        this.byteBuf.appendByte(value);
    }

    @Override
    public void write(int byteValue) {
        this.byteBuf.appendByte((byte)byteValue);
    }

    public void write(boolean value) {
        this.byteBuf.appendByte(value ? (byte)1 : 0);
    }

    public void writeInt(int pos, int value) {
        this.byteBuf.setInt(pos, value);
    }

    public void writeShort(short value) {
        this.byteBuf.appendShort(value);
    }

    public void writeInt(int value) {
        this.byteBuf.appendInt(value);
    }

    public void writeLong(long value) {
        this.byteBuf.appendLong(value);
    }

    public void writeString(String value) {
        this.writeInt(value.length());
        this.byteBuf.appendString(value, StandardCharsets.UTF_8.toString());
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int len) {
        this.byteBuf.appendBytes(bytes, offset, len);
    }

    @Override
    public void close() {
    }

    public int writerIndex() {
        return this.byteBuf.length();
    }
}

