/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.provider.pojo.DefaultMethodMeta;
import org.apache.servicecomb.provider.pojo.FilterInvocationCaller;
import org.apache.servicecomb.provider.pojo.InvocationCaller;
import org.apache.servicecomb.provider.pojo.PojoConsumerMetaRefresher;
import org.apache.servicecomb.provider.pojo.PojoInvocationCreator;

public class Invoker
implements InvocationHandler {
    public static final Method METHOD_HASH_CODE;
    public static final Method METHOD_EQUALS;
    public static final Method METHOD_TO_STRING;
    protected final PojoConsumerMetaRefresher metaRefresher;
    protected final PojoInvocationCreator invocationCreator;
    protected final DefaultMethodMeta defaultMethodMeta = new DefaultMethodMeta();
    protected InvocationCaller invocationCaller;

    public static <T> T createProxy(String microserviceName, String schemaId, Class<?> consumerIntf) {
        Invoker invoker = new Invoker(microserviceName, schemaId, consumerIntf);
        return (T)Proxy.newProxyInstance(consumerIntf.getClassLoader(), new Class[]{consumerIntf}, (InvocationHandler)invoker);
    }

    public Invoker(String microserviceName, String schemaId, Class<?> consumerIntf) {
        this.metaRefresher = this.createInvokerMeta(microserviceName, schemaId, consumerIntf);
        this.invocationCreator = this.createInvocationCreator();
    }

    protected PojoConsumerMetaRefresher createInvokerMeta(String microserviceName, String schemaId, Class<?> consumerIntf) {
        return new PojoConsumerMetaRefresher(microserviceName, schemaId, consumerIntf);
    }

    public PojoInvocationCreator createInvocationCreator() {
        return new PojoInvocationCreator();
    }

    protected InvocationCaller createInvocationCaller() {
        return new FilterInvocationCaller();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.isDefault()) {
            return this.defaultMethodMeta.getOrCreateMethodHandle(proxy, method).invokeWithArguments(args);
        }
        if (METHOD_HASH_CODE.equals(method)) {
            return this.objectHashCode(proxy);
        }
        if (METHOD_EQUALS.equals(method)) {
            return this.objectEquals(proxy, args[0]);
        }
        if (METHOD_TO_STRING.equals(method)) {
            return this.objectToString(proxy);
        }
        SCBEngine.getInstance().ensureStatusUp();
        this.prepareInvocationCaller();
        return this.invocationCaller.call(method, this.metaRefresher, this.invocationCreator, args);
    }

    protected void prepareInvocationCaller() {
        if (this.invocationCaller != null) {
            return;
        }
        this.invocationCaller = this.createInvocationCaller();
    }

    private String objectClassName(Object obj) {
        return obj.getClass().getName();
    }

    private int objectHashCode(Object obj) {
        return System.identityHashCode(obj);
    }

    private boolean objectEquals(Object obj, Object other) {
        return obj == other;
    }

    private String objectToString(Object obj) {
        return this.objectClassName(obj) + "@" + Integer.toHexString(this.objectHashCode(obj));
    }

    static {
        try {
            METHOD_HASH_CODE = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            METHOD_EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
            METHOD_TO_STRING = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }
}

