/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.wavefront;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.tracing.reporter.wavefront.SpanMetrics;
import java.util.concurrent.BlockingQueue;

class MeterRegistrySpanMetrics
implements SpanMetrics {
    private final Counter spansReceived;
    private final Counter spansDropped;
    private final Counter reportErrors;
    private final MeterRegistry meterRegistry;

    MeterRegistrySpanMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        this.spansReceived = meterRegistry.counter("wavefront.reporter.spans.received", new String[0]);
        this.spansDropped = meterRegistry.counter("wavefront.reporter.spans.dropped", new String[0]);
        this.reportErrors = meterRegistry.counter("wavefront.reporter.errors", new String[0]);
    }

    public void reportDropped() {
        this.spansDropped.increment();
    }

    public void reportReceived() {
        this.spansReceived.increment();
    }

    public void reportErrors() {
        this.reportErrors.increment();
    }

    public void registerQueueSize(BlockingQueue<?> queue) {
        this.meterRegistry.gauge("wavefront.reporter.queue.size", queue, q -> q.size());
    }

    public void registerQueueRemainingCapacity(BlockingQueue<?> queue) {
        this.meterRegistry.gauge("wavefront.reporter.queue.remaining_capacity", queue, this::remainingCapacity);
    }

    private double remainingCapacity(BlockingQueue<?> queue) {
        return queue.remainingCapacity();
    }
}

