/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.pprof.storage;

import com.google.gson.Gson;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=92, name="PprofTask")
@Stream(name="pprof_task", scopeId=92, builder=Builder.class, processor=NoneStreamProcessor.class)
@BanyanDB.TimestampColumn(value="create_time")
@BanyanDB.Group(streamGroup=BanyanDB.StreamGroup.RECORDS)
public class PprofTaskRecord
extends NoneStream {
    private static final Gson GSON = new Gson();
    public static final String INDEX_NAME = "pprof_task";
    public static final String TASK_ID = "task_id";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_INSTANCE_IDS = "service_instance_ids";
    public static final String CREATE_TIME = "create_time";
    public static final String EVENT_TYPES = "events";
    public static final String DURATION = "duration";
    public static final String DUMP_PERIOD = "dump_period";
    @Column(name="service_id")
    @BanyanDB.SeriesID(index=0)
    private String serviceId;
    @Column(name="service_instance_ids")
    private String serviceInstanceIds;
    @Column(name="task_id")
    private String taskId;
    @ElasticSearch.EnableDocValues
    @Column(name="create_time")
    private long createTime;
    @ElasticSearch.EnableDocValues
    @Column(name="events")
    private String events;
    @Column(name="duration")
    private int duration;
    @Column(name="dump_period")
    private int dumpPeriod;

    @Override
    public StorageID id() {
        return new StorageID().append(TASK_ID, this.taskId);
    }

    public void setServiceInstanceIdsFromList(List<String> serviceInstanceIds) {
        this.serviceInstanceIds = GSON.toJson(serviceInstanceIds);
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getEvents() {
        return this.events;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public int getDumpPeriod() {
        return this.dumpPeriod;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setServiceInstanceIds(String serviceInstanceIds) {
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setEvents(String events) {
        this.events = events;
    }

    @Generated
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Generated
    public void setDumpPeriod(int dumpPeriod) {
        this.dumpPeriod = dumpPeriod;
    }

    public static class Builder
    implements StorageBuilder<PprofTaskRecord> {
        @Override
        public PprofTaskRecord storage2Entity(Convert2Entity converter) {
            PprofTaskRecord record = new PprofTaskRecord();
            record.setServiceId((String)converter.get(PprofTaskRecord.SERVICE_ID));
            record.setServiceInstanceIds((String)converter.get(PprofTaskRecord.SERVICE_INSTANCE_IDS));
            record.setTaskId((String)converter.get(PprofTaskRecord.TASK_ID));
            record.setCreateTime(((Number)converter.get(PprofTaskRecord.CREATE_TIME)).longValue());
            record.setEvents((String)converter.get(PprofTaskRecord.EVENT_TYPES));
            record.setDuration(((Number)converter.get(PprofTaskRecord.DURATION)).intValue());
            record.setDumpPeriod(((Number)converter.get(PprofTaskRecord.DUMP_PERIOD)).intValue());
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return record;
        }

        @Override
        public void entity2Storage(PprofTaskRecord storageData, Convert2Storage converter) {
            converter.accept(PprofTaskRecord.SERVICE_ID, storageData.getServiceId());
            converter.accept(PprofTaskRecord.SERVICE_INSTANCE_IDS, storageData.getServiceInstanceIds());
            converter.accept(PprofTaskRecord.TASK_ID, storageData.getTaskId());
            converter.accept(PprofTaskRecord.CREATE_TIME, storageData.getCreateTime());
            converter.accept(PprofTaskRecord.EVENT_TYPES, storageData.getEvents());
            converter.accept(PprofTaskRecord.DURATION, storageData.getDuration());
            converter.accept(PprofTaskRecord.DUMP_PERIOD, storageData.getDumpPeriod());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

