/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel.otlp;

import com.google.common.base.Strings;
import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceResponse;
import io.opentelemetry.proto.collector.logs.v1.LogsServiceGrpc;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.logs.v1.LogRecord;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.apm.network.logging.v3.LogDataBody;
import org.apache.skywalking.apm.network.logging.v3.LogTags;
import org.apache.skywalking.apm.network.logging.v3.TextLog;
import org.apache.skywalking.oap.log.analyzer.provider.log.ILogAnalyzerService;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.receiver.otel.Handler;
import org.apache.skywalking.oap.server.receiver.otel.OtelMetricReceiverConfig;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryLogHandler
extends LogsServiceGrpc.LogsServiceImplBase
implements Handler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryLogHandler.class);
    private ModuleManager manager;
    private ILogAnalyzerService logAnalyzerService;
    private final AtomicReference<Object> metricsCreator = new AtomicReference();
    private final AtomicReference<Object> processHistogram = new AtomicReference();

    @Override
    public void init(ModuleManager manager, OtelMetricReceiverConfig config) {
        this.manager = manager;
    }

    @Override
    public String type() {
        return "otlp-logs";
    }

    @Override
    public void active() throws ModuleStartException {
        GRPCHandlerRegister grpcHandlerRegister = (GRPCHandlerRegister)this.manager.find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        grpcHandlerRegister.addHandler((BindableService)this);
    }

    public void export(ExportLogsServiceRequest request, StreamObserver<ExportLogsServiceResponse> responseObserver) {
        request.getResourceLogsList().forEach(resourceLogs -> {
            Resource resource = resourceLogs.getResource();
            Map<String, String> attributes = resource.getAttributesList().stream().map(it -> Map.entry(it.getKey(), this.buildTagValue((KeyValue)it))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            String service = attributes.get("service.name");
            if (Strings.isNullOrEmpty((String)service)) {
                log.warn("No service name found in resource attributes, discarding the log");
                return;
            }
            String layer = attributes.getOrDefault("service.layer", "");
            String serviceInstance = attributes.getOrDefault("service.instance", "");
            resourceLogs.getScopeLogsList().stream().flatMap(it -> it.getLogRecordsList().stream()).forEach(logRecord -> {
                try (HistogramMetrics.Timer timer = this.getProcessHistogram().createTimer();){
                    this.doAnalysisQuietly(service, layer, serviceInstance, (LogRecord)logRecord);
                }
            });
        });
        responseObserver.onNext((Object)ExportLogsServiceResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    private void doAnalysisQuietly(String service, String layer, String serviceInstance, LogRecord logRecord) {
        try {
            this.logAnalyzerService().doAnalysis(LogData.newBuilder().setService(service).setServiceInstance(serviceInstance).setTimestamp(logRecord.getTimeUnixNano() / 1000000L).setTags(this.buildTags(logRecord)).setBody(OpenTelemetryLogHandler.buildBody(logRecord)).setLayer(layer), null);
        }
        catch (Exception e) {
            log.error("Failed to analyze logs", (Throwable)e);
        }
    }

    private static LogDataBody buildBody(LogRecord logRecord) {
        return LogDataBody.newBuilder().setText(TextLog.newBuilder().setText(logRecord.getBody().getStringValue()).build()).build();
    }

    private LogTags buildTags(LogRecord logRecord) {
        return LogTags.newBuilder().addAllData((Iterable)logRecord.getAttributesList().stream().collect(Collectors.toMap(KeyValue::getKey, this::buildTagValue)).entrySet().stream().map(it -> KeyStringValuePair.newBuilder().setKey((String)it.getKey()).setValue((String)it.getValue()).build()).collect(Collectors.toList())).build();
    }

    private String buildTagValue(KeyValue it) {
        AnyValue value = it.getValue();
        return value.hasStringValue() ? value.getStringValue() : (value.hasIntValue() ? String.valueOf(value.getIntValue()) : (value.hasDoubleValue() ? String.valueOf(value.getDoubleValue()) : (value.hasBoolValue() ? String.valueOf(value.getBoolValue()) : (value.hasArrayValue() ? value.getArrayValue().toString() : ""))));
    }

    private ILogAnalyzerService logAnalyzerService() {
        if (this.logAnalyzerService == null) {
            this.logAnalyzerService = (ILogAnalyzerService)this.manager.find("log-analyzer").provider().getService(ILogAnalyzerService.class);
        }
        return this.logAnalyzerService;
    }

    @Generated
    public OpenTelemetryLogHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public MetricsCreator getMetricsCreator() {
        Object value = this.metricsCreator.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.metricsCreator;
            synchronized (atomicReference) {
                value = this.metricsCreator.get();
                if (value == null) {
                    MetricsCreator actualValue = (MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class);
                    value = actualValue == null ? this.metricsCreator : actualValue;
                    this.metricsCreator.set(value);
                }
            }
        }
        return (MetricsCreator)(value == this.metricsCreator ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public HistogramMetrics getProcessHistogram() {
        Object value = this.processHistogram.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.processHistogram;
            synchronized (atomicReference) {
                value = this.processHistogram.get();
                if (value == null) {
                    HistogramMetrics actualValue = this.getMetricsCreator().createHistogramMetric("otel_logs_latency", "The latency to process the logs request", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
                    value = actualValue == null ? this.processHistogram : actualValue;
                    this.processHistogram.set(value);
                }
            }
        }
        return (HistogramMetrics)(value == this.processHistogram ? null : value);
    }
}

