/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1BitStringParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ParsingException;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1StreamParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.BERBitString;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ConstructedBitStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;

public class BERBitStringParser
implements ASN1BitStringParser {
    private ASN1StreamParser _parser;
    private ConstructedBitStream _bitStream;

    BERBitStringParser(ASN1StreamParser aSN1StreamParser) {
        this._parser = aSN1StreamParser;
    }

    public InputStream getBitStream() throws IOException {
        this._bitStream = new ConstructedBitStream(this._parser, false);
        return this._bitStream;
    }

    public int getPadBits() {
        return this._bitStream.getPadBits();
    }

    public ASN1Primitive getLoadedObject() throws IOException {
        return BERBitStringParser.parse(this._parser);
    }

    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("IOException converting stream to byte array: " + iOException.getMessage(), iOException);
        }
    }

    static BERBitString parse(ASN1StreamParser aSN1StreamParser) throws IOException {
        ConstructedBitStream constructedBitStream = new ConstructedBitStream(aSN1StreamParser, false);
        byte[] byArray = Streams.readAll(constructedBitStream);
        int n = constructedBitStream.getPadBits();
        return new BERBitString(byArray, n);
    }
}

