/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import org.apache.log4j.Logger;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.FederatedMonitoringServerHandler;

public class FederatedMonitoringServer {
    protected static Logger log = Logger.getLogger(FederatedMonitoringServer.class);
    private final int _port;
    private final boolean _debug;

    public FederatedMonitoringServer(int port, boolean debug) {
        this._port = port == -1 ? 4201 : port;
        this._debug = debug;
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info((Object)("Setting up Federated Monitoring Backend on port " + this._port));
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            final CorsConfig corsConfig = CorsConfigBuilder.forAnyOrigin().allowedRequestHeaders(new String[]{"*"}).allowedRequestMethods(new HttpMethod[]{HttpMethod.DELETE, HttpMethod.GET, HttpMethod.PUT, HttpMethod.POST, HttpMethod.OPTIONS}).build();
            ServerBootstrap server = new ServerBootstrap();
            ((ServerBootstrap)server.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                    pipeline.addLast(new ChannelHandler[]{new CorsHandler(corsConfig)});
                    pipeline.addLast(new ChannelHandler[]{new FederatedMonitoringServerHandler()});
                }
            });
            server.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            log.info((Object)("Starting Federated Monitoring Backend server at port: " + this._port));
            ChannelFuture f = server.bind(this._port).sync();
            log.info((Object)("Started Federated Monitoring Backend at port: " + this._port));
            f.channel().closeFuture().sync();
        }
        catch (Exception e) {
            log.info((Object)"Federated Monitoring Backend Interrupted");
            if (this._debug) {
                log.error((Object)e.getMessage());
                e.printStackTrace();
            }
        }
        finally {
            log.info((Object)"Federated Monitoring Backend Shutting down.");
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }
}

