/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.AColGroupOffset;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUtils;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupOLE
extends AColGroupOffset {
    private static final long serialVersionUID = 5723227906925121066L;

    private ColGroupOLE(IColIndex colIndices, int numRows, boolean zero, IDictionary dict, char[] bitmaps, int[] bitmapOffs, int[] counts) {
        super(colIndices, numRows, zero, dict, bitmapOffs, bitmaps, counts);
    }

    protected static AColGroup create(IColIndex colIndices, int numRows, boolean zeros, IDictionary dict, char[] bitmaps, int[] bitmapOffs, int[] counts) {
        return new ColGroupOLE(colIndices, numRows, zeros, dict, bitmaps, bitmapOffs, counts);
    }

    protected static AColGroup compressOLE(IColIndex colIndexes, ABitmap ubm, int nRow, double tupleSparsity) {
        IDictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        int numVals = ubm.getNumValues();
        char[][] lBitMaps = new char[numVals][];
        int totalLen = 0;
        for (int i = 0; i < numVals; ++i) {
            lBitMaps[i] = ColGroupOLE.genOffsetBitmap(ubm.getOffsetsList(i).extractValues(), ubm.getNumOffsets(i));
            totalLen += lBitMaps[i].length;
        }
        int[] bitmap = new int[numVals + 1];
        char[] data = new char[totalLen];
        ColGroupOLE.createCompressedBitmaps(bitmap, data, lBitMaps);
        return ColGroupOLE.create(colIndexes, nRow, false, dict, data, bitmap, null);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.OLE;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.OLE;
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToDenseBlockSparseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock values) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToSparseBlockSparseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, SparseBlock sb) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        throw new NotImplementedException();
    }

    @Override
    public int[] getCounts(int[] counts) {
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int blen = this.len(k);
            int count = 0;
            int boff = this._ptr[k];
            for (int bix = 0; bix < blen; bix += this._data[boff + bix] + '\u0001') {
                count += this._data[boff + bix];
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = this._numRows - sum;
        }
        return counts;
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return new ColGroupOLE(this._colIndexes, this._numRows, this._zeros, this._dict.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupOLE(this._colIndexes, this._numRows, false, this._dict.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        throw new NotImplementedException("Not implemented because dictionaries no longer should support extending by a tuple Ideally implement a modification such that OLE becomes SDC group when materializing Zero tuples");
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        throw new NotImplementedException();
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        throw new NotImplementedException();
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        throw new NotImplementedException();
    }

    @Override
    protected final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        throw new NotImplementedException();
    }

    protected boolean[] computeZeroIndicatorVector() {
        boolean[] ret = new boolean[this._numRows];
        int blksz = 65535;
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int off = 0;
            int bix = 0;
            while (bix < blen) {
                int slen = this._data[boff + bix];
                for (int i = 1; i <= slen; ++i) {
                    int n = off + this._data[boff + bix + i];
                    ret[n] = ret[n] & false;
                }
                bix += slen + '\u0001';
                off += 65535;
            }
        }
        return ret;
    }

    @Override
    public double getIdx(int r, int colIdx) {
        int blksz = 65535;
        int numVals = this.getNumValues();
        int[] apos = this.skipScan(numVals, r);
        int offset = r % 65535;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int bix = apos[k];
            int slen = this._data[boff + bix];
            for (int blckIx = 1; blckIx <= slen && blckIx < blen; ++blckIx) {
                if (this._data[boff + bix + blckIx] == offset) {
                    return this._dict.getValue(k * this._colIndexes.size() + colIdx);
                }
                if (this._data[boff + bix + blckIx] <= offset) continue;
            }
        }
        return 0.0;
    }

    private int[] skipScan(int numVals, int rl) {
        int blksz = 65535;
        rl = rl / 65535 * 65535;
        int[] ret = new int[numVals];
        if (rl > 0) {
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int start = 0;
                int bix = 0;
                for (int i = start; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += 65535) {
                }
                ret[k] = bix;
            }
        }
        return ret;
    }

    @Override
    public void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        throw new NotImplementedException();
    }

    @Override
    protected AColGroup allocateRightMultiplication(MatrixBlock right, IColIndex colIndexes, IDictionary preAgg) {
        throw new NotImplementedException();
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        throw new NotImplementedException();
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        throw new NotImplementedException();
    }

    @Override
    public boolean containsValue(double pattern) {
        throw new NotImplementedException();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s%5d", "Pointers:", this._ptr.length));
        sb.append(Arrays.toString(this._ptr));
        sb.append(String.format("\n%15s%5d", "Data:", this._data.length));
        sb.append(ColGroupOLE.charsToString(this._data));
        return sb.toString();
    }

    protected static String charsToString(char[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int x = 0; x < data.length; ++x) {
            sb.append((int)data[x]);
            if (x == data.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static char[] genOffsetBitmap(int[] offsets, int len) {
        if (offsets == null || offsets.length == 0 || len == 0) {
            return null;
        }
        int lastOffset = offsets[len - 1];
        int numBlocks = lastOffset / 65535 + 1;
        int[] blockLengths = new int[numBlocks];
        for (int ix = 0; ix < len; ++ix) {
            int blockForVal;
            int val = offsets[ix];
            int n = blockForVal = val / 65535;
            blockLengths[n] = blockLengths[n] + 1;
        }
        int totalSize = numBlocks;
        for (int block = 0; block < numBlocks; ++block) {
            totalSize += blockLengths[block];
        }
        char[] encodedBlocks = new char[totalSize];
        int inputIx = 0;
        int blockStartIx = 0;
        for (int block = 0; block < numBlocks; ++block) {
            int blockSz = blockLengths[block];
            encodedBlocks[blockStartIx] = (char)blockSz;
            for (int i = 0; i < blockSz; ++i) {
                encodedBlocks[blockStartIx + i + 1] = (char)(offsets[inputIx + i] % 65535);
            }
            inputIx += blockSz;
            blockStartIx += blockSz + 1;
        }
        return encodedBlocks;
    }

    @Override
    public void preAggregateDense(MatrixBlock m, double[] preAgg, int rl, int ru, int cl, int cu) {
        throw new NotImplementedException();
    }

    @Override
    public void leftMMIdentityPreAggregateDense(MatrixBlock that, MatrixBlock ret, int rl, int ru, int cl, int cu) {
        throw new NotImplementedException();
    }

    @Override
    public void preAggregateSparse(SparseBlock sb, double[] preAgg, int rl, int ru, int cl, int cu) {
        throw new NotImplementedException();
    }

    @Override
    protected void preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    protected void preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    protected void preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public boolean sameIndexStructure(AColGroupCompressed that) {
        throw new NotImplementedException();
    }

    @Override
    protected int numRowsToMultiply() {
        throw new NotImplementedException();
    }

    @Override
    protected void preAggregateThatRLEStructure(ColGroupRLE that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        throw new NotImplementedException();
    }

    public static ColGroupOLE read(DataInput in, int nRows) throws IOException {
        IColIndex cols = ColIndexFactory.read(in);
        IDictionary dict = DictionaryFactory.read(in);
        int[] ptr = ColGroupOLE.readPointers(in);
        char[] data = ColGroupOLE.readData(in);
        boolean zeros = in.readBoolean();
        return new ColGroupOLE(cols, nRows, zeros, dict, data, ptr, null);
    }

    @Override
    public AColGroup sliceRows(int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    protected AColGroup copyAndSet(IColIndex colIndexes, IDictionary newDictionary) {
        return ColGroupOLE.create(colIndexes, this._numRows, this._zeros, newDictionary, this._data, this._ptr, this.getCachedCounts());
    }

    @Override
    public AColGroup append(AColGroup g) {
        return null;
    }

    @Override
    public AColGroup appendNInternal(AColGroup[] g, int blen, int rlen) {
        throw new NotImplementedException();
    }

    @Override
    public ICLAScheme getCompressionScheme() {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup recompress() {
        return this;
    }

    @Override
    public CompressedSizeInfoColGroup getCompressionInfo(int nRow) {
        throw new NotImplementedException();
    }

    @Override
    protected AColGroup fixColIndexes(IColIndex newColIndex, int[] reordering) {
        throw new NotImplementedException();
    }

    @Override
    protected void sparseSelection(MatrixBlock selection, ColGroupUtils.P[] points, MatrixBlock ret, int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    protected void denseSelection(MatrixBlock selection, ColGroupUtils.P[] points, MatrixBlock ret, int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToDenseBlockTransposedSparseDictionary(DenseBlock db, int rl, int ru, SparseBlock sb) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToDenseBlockTransposedDenseDictionary(DenseBlock db, int rl, int ru, double[] dict) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToSparseBlockTransposedSparseDictionary(SparseBlockMCSR db, SparseBlock sb, int nColOut) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToSparseBlockTransposedDenseDictionary(SparseBlockMCSR db, double[] dict, int nColOut) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup[] splitReshape(int multiplier, int nRow, int nColOrg) {
        throw new NotImplementedException("Unimplemented method 'splitReshape'");
    }
}

