/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.InputStreamInputFormat;

public class FrameReaderTextCSV
extends FrameReader {
    protected final FileFormatPropertiesCSV _props;

    public FrameReaderTextCSV(FileFormatPropertiesCSV props) {
        this._props = props != null ? props : new FileFormatPropertiesCSV();
    }

    @Override
    public final FrameBlock readFrameFromHDFS(String fname, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        FrameReaderTextCSV.checkValidInputFile(fs, path);
        if (rlen <= 0L || clen <= 0L) {
            Pair<Integer, Integer> size = this.computeCSVSize(path, job, fs);
            rlen = size.getKey().intValue();
            clen = size.getValue().intValue();
        }
        Types.ValueType[] lschema = FrameReaderTextCSV.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderTextCSV.createOutputNames(names, clen);
        FrameBlock ret = FrameReaderTextCSV.createOutputFrameBlock(lschema, lnames, rlen);
        this.readCSVFrameFromHDFS(path, job, fs, ret, lschema, lnames, rlen, clen);
        return ret;
    }

    @Override
    public FrameBlock readFrameFromInputStream(InputStream is, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        Types.ValueType[] lschema = FrameReaderTextCSV.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderTextCSV.createOutputNames(names, clen);
        FrameBlock ret = FrameReaderTextCSV.createOutputFrameBlock(lschema, lnames, rlen);
        InputStreamInputFormat informat = new InputStreamInputFormat(is);
        InputSplit split = informat.getSplits(null, 1)[0];
        this.readCSVFrameFromInputSplit(split, informat, null, ret, schema, names, rlen, clen, 0, true);
        return ret;
    }

    protected void readCSVFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        if (HDFSTool.isDirectory(fs, path)) {
            splits = IOUtilFunctions.sortInputSplits(splits);
        }
        int rpos = 0;
        for (int i = 0; i < splits.length; ++i) {
            rpos = this.readCSVFrameFromInputSplit(splits[i], (InputFormat<LongWritable, Text>)informat, job, dest, schema, names, rlen, clen, rpos, i == 0);
        }
    }

    protected final int readCSVFrameFromInputSplit(InputSplit split, InputFormat<LongWritable, Text> informat, JobConf job, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen, int rl, boolean first) throws IOException {
        if ((long)rl > rlen) {
            throw new DMLRuntimeException("Invalid offset");
        }
        boolean hasHeader = this._props.hasHeader();
        boolean isFill = this._props.isFill();
        double dfillValue = this._props.getFillValue();
        String sfillValue = String.valueOf(this._props.getFillValue());
        HashSet<String> naValues = this._props.getNAStrings();
        String delim = this._props.getDelim();
        CellAssigner f = naValues != null ? FrameReaderTextCSV::assignCellGeneric : (isFill && dfillValue != 0.0 ? FrameReaderTextCSV::assignCellFill : FrameReaderTextCSV::assignCellNoFill);
        RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
        LongWritable key = new LongWritable();
        Text value = new Text();
        if (first && hasHeader) {
            reader.next((Object)key, (Object)value);
            dest.setColumnNames(value.toString().split(delim));
        }
        int row = rl;
        try {
            Array<?>[] destA = dest.getColumns();
            while (reader.next((Object)key, (Object)value)) {
                String line = value.toString();
                if (FrameReaderTextCSV.isMetaStart(line)) {
                    FrameReaderTextCSV.parseMeta(line, delim, dest);
                    continue;
                }
                FrameReaderTextCSV.parseLine(line, delim, destA, row, (int)clen, dfillValue, sfillValue, isFill, naValues, f);
                ++row;
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Failed parsing string: \"" + value + "\"", e);
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
        return row;
    }

    private static boolean isMetaStart(String s) {
        return s.charAt(0) == '#' && s.substring(0, 5).equals("#Meta");
    }

    private static void parseMeta(String s, String delim, FrameBlock dest) {
        String[] parts = IOUtilFunctions.splitCSV(s, delim);
        boolean mtdP = parts[0].equals("#Meta\u00b7MV");
        boolean mtdx = parts[0].equals("#Meta\u00b7ND");
        if (parts.length != dest.getNumColumns() + 1) {
            LOG.warn((Object)"Invalid metadata ");
            parts = null;
            return;
        }
        if (mtdP) {
            for (int j = 0; j < dest.getNumColumns(); ++j) {
                dest.getColumnMetadata(j).setMvValue(parts[j + 1]);
            }
        } else if (mtdx) {
            for (int j = 0; j < dest.getNumColumns(); ++j) {
                dest.getColumnMetadata(j).setNumDistinct(Long.parseLong(parts[j + 1]));
            }
        }
        parts = null;
    }

    private static void parseLine(String cellStr, String delim, Array<?>[] destA, int row, int clen, double dfillValue, String sfillValue, boolean isFill, Set<String> naValues, CellAssigner assigner) {
        try {
            String trimmed = IOUtilFunctions.trim(cellStr);
            int len = trimmed.length();
            int delimLen = delim.length();
            FrameReaderTextCSV.parseLineSpecialized(trimmed, delim, destA, row, dfillValue, sfillValue, isFill, naValues, len, delimLen, assigner);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to parse: " + cellStr, e);
        }
    }

    private static void parseLineSpecialized(String cellStr, String delim, Array<?>[] destA, int row, double dfillValue, String sfillValue, boolean isFill, Set<String> naValues, int len, int delimLen, CellAssigner assigner) {
        int from = 0;
        int to = 0;
        int c = 0;
        while (from < len) {
            to = IOUtilFunctions.getTo(cellStr, from, delim, len, delimLen);
            String s = cellStr.substring(from, to);
            assigner.assign(row, destA[c], s, to - from, naValues, isFill, dfillValue, sfillValue);
            ++c;
            from = to + delimLen;
        }
    }

    private static void assignCellNoFill(int row, Array<?> dest, String val, int length, Set<String> naValues, boolean isFill, double dfillValue, String sfillValue) {
        if (length != 0) {
            String part = IOUtilFunctions.trim(val, length);
            if (part.isEmpty()) {
                return;
            }
            dest.set(row, part);
        }
    }

    private static void assignCellFill(int row, Array<?> dest, String val, int length, Set<String> naValues, boolean isFill, double dfillValue, String sfillValue) {
        if (length == 0) {
            dest.set(row, sfillValue);
        } else {
            String part = IOUtilFunctions.trim(val, length);
            if (part == null || part.isEmpty()) {
                dest.set(row, sfillValue);
            } else {
                dest.set(row, part);
            }
        }
    }

    private static void assignCellGeneric(int row, Array<?> dest, String val, int length, Set<String> naValues, boolean isFill, double dfillValue, String sfillValue) {
        if (length == 0) {
            if (isFill && dfillValue != 0.0) {
                dest.set(row, sfillValue);
            }
        } else {
            String part = IOUtilFunctions.trim(val, length);
            if (part == null || part.isEmpty() || naValues != null && naValues.contains(part)) {
                if (isFill && dfillValue != 0.0) {
                    dest.set(row, sfillValue);
                }
            } else {
                dest.set(row, part);
            }
        }
    }

    protected Pair<Integer, Integer> computeCSVSize(Path path, JobConf job, FileSystem fs) throws IOException {
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        splits = IOUtilFunctions.sortInputSplits(splits);
        int ncol = IOUtilFunctions.countNumColumnsCSV(splits, (InputFormat)informat, job, this._props.getDelim());
        int nrow = 0;
        for (int i = 0; i < splits.length; ++i) {
            boolean header = i == 0 && this._props.hasHeader();
            nrow = (int)((long)nrow + FrameReaderTextCSV.countLinesInSplit(splits[i], informat, job, header));
        }
        return new Pair<Integer, Integer>(nrow, ncol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long countLinesInSplit(InputSplit split, TextInputFormat inFormat, JobConf job, boolean header) throws IOException {
        RecordReader reader = inFormat.getRecordReader(split, job, Reporter.NULL);
        try {
            long l = FrameReaderTextCSV.countLinesInReader((RecordReader<LongWritable, Text>)reader, header);
            return l;
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
    }

    private static int countLinesInReader(RecordReader<LongWritable, Text> reader, boolean header) throws IOException {
        LongWritable key = new LongWritable();
        Text value = new Text();
        int nrow = 0;
        if (header) {
            reader.next((Object)key, (Object)value);
        }
        while (reader.next((Object)key, (Object)value)) {
            if (nrow < 3) {
                String sval = IOUtilFunctions.trim(value.toString());
                boolean containsMTD = sval.startsWith("#Meta\u00b7MV") || sval.startsWith("#Meta\u00b7ND");
                nrow += containsMTD ? 0 : 1;
                continue;
            }
            ++nrow;
        }
        return nrow;
    }

    @FunctionalInterface
    private static interface CellAssigner {
        public void assign(int var1, Array<?> var2, String var3, int var4, Set<String> var5, boolean var6, double var7, String var9);
    }
}

