/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.tinkerpop.gremlin.server.AbstractChannelizer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AllowAllAuthenticator;
import org.apache.tinkerpop.gremlin.server.handler.AbstractAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.GremlinResponseFrameEncoder;
import org.apache.tinkerpop.gremlin.server.handler.SaslAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.WebSocketAuthorizationHandler;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinBinaryRequestDecoder;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinCloseRequestDecoder;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinResponseFrameEncoder;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinTextRequestDecoder;
import org.apache.tinkerpop.gremlin.server.handler.WsUserAgentHandler;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketChannelizer
extends AbstractChannelizer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketChannelizer.class);
    private GremlinResponseFrameEncoder gremlinResponseFrameEncoder;
    private WsGremlinTextRequestDecoder wsGremlinTextRequestDecoder;
    private WsGremlinBinaryRequestDecoder wsGremlinBinaryRequestDecoder;
    private WsGremlinResponseFrameEncoder wsGremlinResponseFrameEncoder;
    private WsGremlinCloseRequestDecoder wsGremlinCloseRequestDecoder;
    private AbstractAuthenticationHandler authenticationHandler;
    private ChannelInboundHandlerAdapter authorizationHandler;

    @Override
    public void init(ServerGremlinExecutor serverGremlinExecutor) {
        super.init(serverGremlinExecutor);
        this.gremlinResponseFrameEncoder = new GremlinResponseFrameEncoder();
        this.wsGremlinTextRequestDecoder = new WsGremlinTextRequestDecoder(this.serializers);
        this.wsGremlinBinaryRequestDecoder = new WsGremlinBinaryRequestDecoder(this.serializers);
        this.wsGremlinCloseRequestDecoder = new WsGremlinCloseRequestDecoder(this.serializers);
        this.wsGremlinResponseFrameEncoder = new WsGremlinResponseFrameEncoder();
        AbstractAuthenticationHandler abstractAuthenticationHandler = this.authenticationHandler = this.authenticator.getClass() == AllowAllAuthenticator.class ? null : this.instantiateAuthenticationHandler(this.settings);
        if (this.authorizer != null) {
            this.authorizationHandler = new WebSocketAuthorizationHandler(this.authorizer);
        }
    }

    @Override
    public void configure(ChannelPipeline pipeline) {
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-encoder-aggregator", LogLevel.DEBUG)});
        }
        pipeline.addLast("http-response-encoder", (ChannelHandler)new HttpResponseEncoder());
        logger.debug("HttpRequestDecoder settings - maxInitialLineLength={}, maxHeaderSize={}, maxChunkSize={}", new Object[]{this.settings.maxInitialLineLength, this.settings.maxHeaderSize, this.settings.maxChunkSize});
        pipeline.addLast("http-request-decoder", (ChannelHandler)new HttpRequestDecoder(this.settings.maxInitialLineLength, this.settings.maxHeaderSize, this.settings.maxChunkSize));
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-decoder-aggregator", LogLevel.DEBUG)});
        }
        logger.debug("HttpObjectAggregator settings - maxContentLength={}, maxAccumulationBufferComponents={}", (Object)this.settings.maxContentLength, (Object)this.settings.maxAccumulationBufferComponents);
        HttpObjectAggregator aggregator = new HttpObjectAggregator(this.settings.maxContentLength);
        aggregator.setMaxCumulationBufferComponents(this.settings.maxAccumulationBufferComponents);
        pipeline.addLast("http-aggregator", (ChannelHandler)aggregator);
        pipeline.addLast("web-socket-server-compression-handler", (ChannelHandler)new WebSocketServerCompressionHandler());
        WebSocketDecoderConfig wsDecoderConfig = WebSocketDecoderConfig.newBuilder().closeOnProtocolViolation(false).allowExtensions(true).maxFramePayloadLength(this.settings.maxContentLength).build();
        pipeline.addLast("request-handler", (ChannelHandler)new WebSocketServerProtocolHandler("/gremlin", null, false, false, 10000L, wsDecoderConfig));
        pipeline.addLast("ws-user-agent-handler", (ChannelHandler)new WsUserAgentHandler());
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-aggregator-encoder", LogLevel.DEBUG)});
        }
        pipeline.addLast("ws-frame-encoder", (ChannelHandler)this.wsGremlinResponseFrameEncoder);
        pipeline.addLast("response-frame-encoder", (ChannelHandler)this.gremlinResponseFrameEncoder);
        pipeline.addLast("request-text-decoder", (ChannelHandler)this.wsGremlinTextRequestDecoder);
        pipeline.addLast("request-binary-decoder", (ChannelHandler)this.wsGremlinBinaryRequestDecoder);
        pipeline.addLast("request-close-decoder", (ChannelHandler)this.wsGremlinCloseRequestDecoder);
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-aggregator-encoder", LogLevel.DEBUG)});
        }
        if (this.authenticationHandler != null) {
            pipeline.addLast("authenticator", (ChannelHandler)this.authenticationHandler);
        }
        if (this.authorizationHandler != null) {
            pipeline.addLast("authorizer", (ChannelHandler)this.authorizationHandler);
        }
    }

    @Override
    public boolean supportsIdleMonitor() {
        return true;
    }

    @Override
    public Object createIdleDetectionMessage() {
        return new PingWebSocketFrame();
    }

    private AbstractAuthenticationHandler instantiateAuthenticationHandler(Settings settings) {
        String authenticationHandler = settings.authentication.authenticationHandler;
        if (authenticationHandler == null) {
            return new SaslAuthenticationHandler(this.authenticator, settings);
        }
        return this.createAuthenticationHandler(settings);
    }
}

