/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ClassLoaderAwareHandler
implements InvocationHandler {
    private static final Class<?>[] RUNNABLE_API = new Class[]{Runnable.class};
    private final ClassLoader loader;
    private final Object delegate;

    public ClassLoaderAwareHandler(ClassLoader contextClassLoader, Object instance) {
        this.loader = contextClassLoader;
        this.delegate = instance;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            Object object = method.invoke(this.delegate, args);
            return object;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    public static <T> T makeLoaderAware(Class<T> mainApi, Class<?>[] clazz, Object instance) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return mainApi.cast(Proxy.newProxyInstance(contextClassLoader, clazz, (InvocationHandler)new ClassLoaderAwareHandler(contextClassLoader, instance)));
    }

    public static Runnable runnableLoaderAware(Object instance) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return (Runnable)Runnable.class.cast(Proxy.newProxyInstance(contextClassLoader, RUNNABLE_API, (InvocationHandler)new ClassLoaderAwareHandler(contextClassLoader, instance)));
    }
}

