/*
 File: testout_err_hdlr.h
 Date and Time: Sat Jan 31 11:59:00 2015 
*/
#ifndef __testout_err_hdlr_h__
#define __testout_err_hdlr_h__ 1
#include "yacco2.h"
#include "testout_T_enumeration.h"
#include "yacco2_k_symbols.h"
#include "testout_err_symbols.h"
#include "testout_terminals.h"
#include "yacco2_characters.h"
// monolithic grammar: no thread
extern yacco2::State S1_Ctestout_err_hdlr;
namespace NS_testout_err_hdlr {
using namespace NS_testout_T_enum;// enumerate
using namespace yacco2;
struct fsm_rules_reuse_table_type{
 fsm_rules_reuse_table_type();
 int no_rules_entries_;
 Per_rule_s_reuse_table* per_rule_s_table_[3];
};
class Ctestout_err_hdlr: public yacco2::CAbs_fsm {
 public:
  enum rules_and_subrules{
   start_of_rule_list = NS_testout_T_enum::T_Enum::sum_total_T
   ,R_Rtestout_err_hdlr_ = 269//start_of_rule_list + 0
    ,rhs1_Rtestout_err_hdlr_ = 1
    ,rhs2_Rtestout_err_hdlr_ = 2
   ,R_Rerrors_ = 270//start_of_rule_list + 2
    ,rhs1_Rerrors_ = 3
    ,rhs2_Rerrors_ = 4
   ,R_Rerror_ = 271//start_of_rule_list + 4
    ,rhs1_Rerror_ = 5
    ,rhs2_Rerror_ = 6
    ,rhs3_Rerror_ = 7
  };
  //no of la sets = 2
  //no of states = 9
  Ctestout_err_hdlr();
  ~Ctestout_err_hdlr();
  void op();
  bool failed();
  void reduce_rhs_of_rule
      (yacco2::UINT Sub_rule_no,yacco2::Rule_s_reuse_entry** Recycled_rule);
  fsm_rules_reuse_table_type fsm_rules_reuse_table;
  static int rhs_to_rules_mapping_[8];
 };
struct Rtestout_err_hdlr;
struct Rerrors;
struct Rerror;
struct Rtestout_err_hdlr:public yacco2::CAbs_lr1_sym {
  Rtestout_err_hdlr(yacco2::Parser* P);
  public:
};

struct Rerrors:public yacco2::CAbs_lr1_sym {
  Rerrors(yacco2::Parser* P);
  public:
};

struct Rerror:public yacco2::CAbs_lr1_sym {
  Rerror(yacco2::Parser* P);

  void error_where(CAbs_lr1_sym* E_sym){
    std::string ext_fle;
      if(E_sym->tok_co_ords__.external_file_id__<yacco2::FILE_TBL__.size()){
        ext_fle = yacco2::FILE_TBL__[E_sym->tok_co_ords__.external_file_id__];
}else{
        ext_fle = "File not found";
}
    std::string line_of_data;
    std::ifstream ifile;
    ifile.open(ext_fle.c_str());
    if(ifile.good()){
        yacco2::UINT lno(1);yacco2::UINT dlno(E_sym->tok_co_ords__.line_no__);
        for(;lno<=dlno;++lno){
          getline(ifile,line_of_data);
          if(lno == dlno) break;
          line_of_data.clear();
        }      
    }      

    std::string space(" ");
    std::string::size_type f = line_of_data.find_first_of('\t');
    for(;f != std::string::npos;){
     line_of_data.replace(f,1,space);
     f = line_of_data.find_first_of('\t');
    }
    
    yacco2::lrclog << "Error in file#: " << E_sym->tok_co_ords__.external_file_id__
		<< " \"" << ext_fle.c_str() << "\"" << std::endl;
	yacco2::lrclog << line_of_data.c_str() << std::endl;
    std::cout << "Error in file#: " << E_sym->tok_co_ords__.external_file_id__
		<< " \"" << ext_fle.c_str() << "\"" << std::endl;
	std::cout << line_of_data.c_str() << std::endl;
	for(int pos = 1;pos < E_sym->tok_co_ords__.pos_in_line__;++pos){
	 yacco2::lrclog << ' ';
	 std::cout << ' ';
	}
	yacco2::lrclog << '^' << std::endl;
	yacco2::lrclog << "\tfpos: " << E_sym->tok_co_ords__.rc_pos__
		<< " line#: " << E_sym->tok_co_ords__.line_no__
		<< " cpos: " << E_sym->tok_co_ords__.pos_in_line__
		<< std::endl;
	std::cout << '^' << std::endl;
	std::cout << "\tfpos: " << E_sym->tok_co_ords__.rc_pos__
		<< " line#: " << E_sym->tok_co_ords__.line_no__
		<< " cpos: " << E_sym->tok_co_ords__.pos_in_line__
		<< std::endl;
		if(E_sym->tok_co_ords__.who_file__ != 0){
			yacco2::lrclog << "\twho thru it: " << E_sym->tok_co_ords__.who_file__
				<< " line#: " << E_sym->tok_co_ords__.who_line_no__
				<< std::endl;
			std::cout << "\twho thru it: " << E_sym->tok_co_ords__.who_file__
				<< " line#: " << E_sym->tok_co_ords__.who_line_no__
				<< std::endl;
		}
    ifile.close();
  };
  
  public:
  void sr1();
  void sr2();
  void sr3();
};

} // end of namespace

#endif
