@q File: o2linker_def.w @>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>
\input "supp-pdf"
\input "/usr/local/yacco2/diagrams/o2mac.tex"
\IDXlinkerdoctitle{o2linker\_doc.w}{o2linker\_doc.w}{/yacco2/compiler/grammars/yacco2.fsc}
@** O2linker Index of Grammars.\fbreak
The grammars are sorted lexicographically into 2 parts:
threads followed by the stand alone grammars.
Each grammar's called threads graph is determined from their 
 ``list-of-transitive-threads''
derived from this construct.
@*2 TH\_angled\_string --- Angled string lexer: \LTsign ... \GTsign with c type$\ldots$ .
\Linkeridxentryk{Angled string lexer: \LTsign ... \GTsign with c type escape sequences.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_angled\_string}{1}
@.TH\_angled\_string@>
{\parindent=6pc
\item{First set:}
raw\_less\_than
@.raw\_less\_than@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_bad\_char\_set --- Bad source character set recognizer.
\Linkeridxentryk{Bad source character set recognizer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_bad\_char\_set}{1}
@.TH\_bad\_char\_set@>
{\parindent=6pc
\item{First set:}
raw\_nul
@.raw\_nul@>
raw\_soh
@.raw\_soh@>
raw\_stx
@.raw\_stx@>
raw\_etx
@.raw\_etx@>
raw\_eot
@.raw\_eot@>
raw\_enq
@.raw\_enq@>
raw\_ack
@.raw\_ack@>
raw\_bel
@.raw\_bel@>
raw\_bs
@.raw\_bs@>
raw\_so
@.raw\_so@>
raw\_si
@.raw\_si@>
raw\_dle
@.raw\_dle@>
raw\_dc1
@.raw\_dc1@>
raw\_dc2
@.raw\_dc2@>
raw\_dc3
@.raw\_dc3@>
raw\_dc4
@.raw\_dc4@>
raw\_nak
@.raw\_nak@>
raw\_syn
@.raw\_syn@>
raw\_etb
@.raw\_etb@>
raw\_can
@.raw\_can@>
raw\_em
@.raw\_em@>
raw\_sub
@.raw\_sub@>
raw\_esc
@.raw\_esc@>
raw\_fs
@.raw\_fs@>
raw\_gs
@.raw\_gs@>
raw\_rs
@.raw\_rs@>
raw\_us
@.raw\_us@>
raw\_del
@.raw\_del@>
raw\_x80
@.raw\_x80@>
raw\_x81
@.raw\_x81@>
raw\_x82
@.raw\_x82@>
raw\_x83
@.raw\_x83@>
raw\_x84
@.raw\_x84@>
raw\_x85
@.raw\_x85@>
raw\_x86
@.raw\_x86@>
raw\_x87
@.raw\_x87@>
raw\_x88
@.raw\_x88@>
raw\_x89
@.raw\_x89@>
raw\_x8a
@.raw\_x8a@>
raw\_x8b
@.raw\_x8b@>
raw\_x8c
@.raw\_x8c@>
raw\_x8d
@.raw\_x8d@>
raw\_x8e
@.raw\_x8e@>
raw\_x8f
@.raw\_x8f@>
raw\_x90
@.raw\_x90@>
raw\_x91
@.raw\_x91@>
raw\_x92
@.raw\_x92@>
raw\_x93
@.raw\_x93@>
raw\_x94
@.raw\_x94@>
raw\_x95
@.raw\_x95@>
raw\_x96
@.raw\_x96@>
raw\_x97
@.raw\_x97@>
raw\_x98
@.raw\_x98@>
raw\_x99
@.raw\_x99@>
raw\_x9a
@.raw\_x9a@>
raw\_x9b
@.raw\_x9b@>
raw\_x9c
@.raw\_x9c@>
raw\_x9d
@.raw\_x9d@>
raw\_x9e
@.raw\_x9e@>
raw\_x9f
@.raw\_x9f@>
raw\_xa0
@.raw\_xa0@>
raw\_xa1
@.raw\_xa1@>
raw\_xa2
@.raw\_xa2@>
raw\_xa3
@.raw\_xa3@>
raw\_xa4
@.raw\_xa4@>
raw\_xa5
@.raw\_xa5@>
raw\_xa6
@.raw\_xa6@>
raw\_xa7
@.raw\_xa7@>
raw\_xa8
@.raw\_xa8@>
raw\_xa9
@.raw\_xa9@>
raw\_xaa
@.raw\_xaa@>
raw\_xab
@.raw\_xab@>
raw\_xac
@.raw\_xac@>
raw\_xad
@.raw\_xad@>
raw\_xae
@.raw\_xae@>
raw\_xaf
@.raw\_xaf@>
raw\_xb0
@.raw\_xb0@>
raw\_xb1
@.raw\_xb1@>
raw\_xb2
@.raw\_xb2@>
raw\_xb3
@.raw\_xb3@>
raw\_xb4
@.raw\_xb4@>
raw\_xb5
@.raw\_xb5@>
raw\_xb6
@.raw\_xb6@>
raw\_xb7
@.raw\_xb7@>
raw\_xb8
@.raw\_xb8@>
raw\_xb9
@.raw\_xb9@>
raw\_xba
@.raw\_xba@>
raw\_xbb
@.raw\_xbb@>
raw\_xbc
@.raw\_xbc@>
raw\_xbd
@.raw\_xbd@>
raw\_xbe
@.raw\_xbe@>
raw\_xbf
@.raw\_xbf@>
raw\_xc0
@.raw\_xc0@>
raw\_xc1
@.raw\_xc1@>
raw\_xc2
@.raw\_xc2@>
raw\_xc3
@.raw\_xc3@>
raw\_xc4
@.raw\_xc4@>
raw\_xc5
@.raw\_xc5@>
raw\_xc6
@.raw\_xc6@>
raw\_xc7
@.raw\_xc7@>
raw\_xc8
@.raw\_xc8@>
raw\_xc9
@.raw\_xc9@>
raw\_xca
@.raw\_xca@>
raw\_xcb
@.raw\_xcb@>
raw\_xcc
@.raw\_xcc@>
raw\_xcd
@.raw\_xcd@>
raw\_xce
@.raw\_xce@>
raw\_xcf
@.raw\_xcf@>
raw\_xd0
@.raw\_xd0@>
raw\_xd1
@.raw\_xd1@>
raw\_xd2
@.raw\_xd2@>
raw\_xd3
@.raw\_xd3@>
raw\_xd4
@.raw\_xd4@>
raw\_xd5
@.raw\_xd5@>
raw\_xd6
@.raw\_xd6@>
raw\_xd7
@.raw\_xd7@>
raw\_xd8
@.raw\_xd8@>
raw\_xd9
@.raw\_xd9@>
raw\_xda
@.raw\_xda@>
raw\_xdb
@.raw\_xdb@>
raw\_xdc
@.raw\_xdc@>
raw\_xdd
@.raw\_xdd@>
raw\_xde
@.raw\_xde@>
raw\_xdf
@.raw\_xdf@>
raw\_xe0
@.raw\_xe0@>
raw\_xe1
@.raw\_xe1@>
raw\_xe2
@.raw\_xe2@>
raw\_xe3
@.raw\_xe3@>
raw\_xe4
@.raw\_xe4@>
raw\_xe5
@.raw\_xe5@>
raw\_xe6
@.raw\_xe6@>
raw\_xe7
@.raw\_xe7@>
raw\_xe8
@.raw\_xe8@>
raw\_xe9
@.raw\_xe9@>
raw\_xea
@.raw\_xea@>
raw\_xeb
@.raw\_xeb@>
raw\_xec
@.raw\_xec@>
raw\_xed
@.raw\_xed@>
raw\_xee
@.raw\_xee@>
raw\_xef
@.raw\_xef@>
raw\_xf0
@.raw\_xf0@>
raw\_xf1
@.raw\_xf1@>
raw\_xf2
@.raw\_xf2@>
raw\_xf3
@.raw\_xf3@>
raw\_xf4
@.raw\_xf4@>
raw\_xf5
@.raw\_xf5@>
raw\_xf6
@.raw\_xf6@>
raw\_xf7
@.raw\_xf7@>
raw\_xf8
@.raw\_xf8@>
raw\_xf9
@.raw\_xf9@>
raw\_xfa
@.raw\_xfa@>
raw\_xfb
@.raw\_xfb@>
raw\_xfc
@.raw\_xfc@>
raw\_xfd
@.raw\_xfd@>
raw\_xfe
@.raw\_xfe@>
raw\_xff
@.raw\_xff@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_cweb\_comments --- CWEB comments containing directives.
\Linkeridxentryk{CWEB comments containing directives.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_cweb\_comments}{1}
@.TH\_cweb\_comments@>
{\parindent=6pc
\item{First set:}
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_cweb\_or\_c\_k --- C++ or cweb type comments lexer.
\Linkeridxentryk{C++ or cweb type comments lexer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_cweb\_or\_c\_k}{1}
@.TH\_cweb\_or\_c\_k@>
{\parindent=6pc
\item{First set:}
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_c\_comments --- C++ type comments lexer.
\Linkeridxentryk{C++ type comments lexer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_c\_comments}{1}
@.TH\_c\_comments@>
{\parindent=6pc
\item{First set:}
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_c\_literal --- C literal lexer.
\Linkeridxentryk{C literal lexer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_c\_literal}{1}
@.TH\_c\_literal@>
{\parindent=6pc
\item{First set:}
raw\_right\_quote
@.raw\_right\_quote@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_c\_string --- C string lexer.
\Linkeridxentryk{C string lexer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_c\_string}{1}
@.TH\_c\_string@>
{\parindent=6pc
\item{First set:}
raw\_dbl\_quote
@.raw\_dbl\_quote@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_dbl\_colon --- This one's for the thread's name :: lexer.
\Linkeridxentryk{This one's for the thread's name :: lexer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_dbl\_colon}{1}
@.TH\_dbl\_colon@>
{\parindent=6pc
\item{First set:}
raw\_colon
@.raw\_colon@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_eol --- end-of-line recognizer --- Unix, Mac, and Microsoft supported s$\ldots$ .
\Linkeridxentryk{end-of-line recognizer --- Unix, Mac, and Microsoft supported styles.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_eol}{1}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
raw\_lf
@.raw\_lf@>
raw\_cr
@.raw\_cr@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_err\_symbols\_ph\_th --- Parse Error vocabulary.
\Linkeridxentryk{Parse Error vocabulary.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_err\_symbols\_ph\_th}{1}
@.TH\_err\_symbols\_ph\_th@>
\Linkercalledthreads{TH\_lint\_balls}{2}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{3}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_open\_bracket
@.raw\_open\_bracket@>
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_term\_def\_ph
@.TH\_term\_def\_ph@>
}
@*2 TH\_esc\_seq --- C type escape sequence recognizer.
\Linkeridxentryk{C type escape sequence recognizer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_esc\_seq}{1}
@.TH\_esc\_seq@>
{\parindent=6pc
\item{First set:}
raw\_back\_slash
@.raw\_back\_slash@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_fsm\_class\_phrase\_th --- Parse the fsm-class grammar construct.
\Linkeridxentryk{Parse the fsm-class grammar construct.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_fsm\_class\_phrase\_th}{1}
@.TH\_fsm\_class\_phrase\_th@>
\Linkercalledthreads{TH\_identifier}{2}
@.TH\_identifier@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_A
@.raw\_A@>
raw\_B
@.raw\_B@>
raw\_C
@.raw\_C@>
raw\_D
@.raw\_D@>
raw\_E
@.raw\_E@>
raw\_F
@.raw\_F@>
raw\_G
@.raw\_G@>
raw\_H
@.raw\_H@>
raw\_I
@.raw\_I@>
raw\_J
@.raw\_J@>
raw\_K
@.raw\_K@>
raw\_L
@.raw\_L@>
raw\_M
@.raw\_M@>
raw\_N
@.raw\_N@>
raw\_O
@.raw\_O@>
raw\_P
@.raw\_P@>
raw\_Q
@.raw\_Q@>
raw\_R
@.raw\_R@>
raw\_S
@.raw\_S@>
raw\_T
@.raw\_T@>
raw\_U
@.raw\_U@>
raw\_V
@.raw\_V@>
raw\_W
@.raw\_W@>
raw\_X
@.raw\_X@>
raw\_Y
@.raw\_Y@>
raw\_Z
@.raw\_Z@>
raw\_a
@.raw\_a@>
raw\_b
@.raw\_b@>
raw\_c
@.raw\_c@>
raw\_d
@.raw\_d@>
raw\_e
@.raw\_e@>
raw\_f
@.raw\_f@>
raw\_g
@.raw\_g@>
raw\_h
@.raw\_h@>
raw\_i
@.raw\_i@>
raw\_j
@.raw\_j@>
raw\_k
@.raw\_k@>
raw\_l
@.raw\_l@>
raw\_m
@.raw\_m@>
raw\_n
@.raw\_n@>
raw\_o
@.raw\_o@>
raw\_p
@.raw\_p@>
raw\_q
@.raw\_q@>
raw\_r
@.raw\_r@>
raw\_s
@.raw\_s@>
raw\_t
@.raw\_t@>
raw\_u
@.raw\_u@>
raw\_v
@.raw\_v@>
raw\_w
@.raw\_w@>
raw\_x
@.raw\_x@>
raw\_y
@.raw\_y@>
raw\_z
@.raw\_z@>
{\parindent=6pc
\item{Used threads:}
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_sdc
@.TH\_o2\_sdc@>
}
@*2 TH\_fsm\_phrase\_th --- Parse grammar's fsm phrase along with its directive$\ldots$ .
\Linkeridxentryk{Parse grammar's fsm phrase along with its directives.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_fsm\_phrase\_th}{1}
@.TH\_fsm\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{2}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{3}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_open\_bracket
@.raw\_open\_bracket@>
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_string
@.TH\_c\_string@>
TH\_fsm\_class\_phrase\_th
@.TH\_fsm\_class\_phrase\_th@>
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
}
@*2 TH\_identifier --- Yacco2 identifiers lexer with symbol table lookup.
\Linkeridxentryk{Yacco2 identifiers lexer with symbol table lookup.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_identifier}{1}
@.TH\_identifier@>
{\parindent=6pc
\item{First set:}
raw\_A
@.raw\_A@>
raw\_B
@.raw\_B@>
raw\_C
@.raw\_C@>
raw\_D
@.raw\_D@>
raw\_E
@.raw\_E@>
raw\_F
@.raw\_F@>
raw\_G
@.raw\_G@>
raw\_H
@.raw\_H@>
raw\_I
@.raw\_I@>
raw\_J
@.raw\_J@>
raw\_K
@.raw\_K@>
raw\_L
@.raw\_L@>
raw\_M
@.raw\_M@>
raw\_N
@.raw\_N@>
raw\_O
@.raw\_O@>
raw\_P
@.raw\_P@>
raw\_Q
@.raw\_Q@>
raw\_R
@.raw\_R@>
raw\_S
@.raw\_S@>
raw\_T
@.raw\_T@>
raw\_U
@.raw\_U@>
raw\_V
@.raw\_V@>
raw\_W
@.raw\_W@>
raw\_X
@.raw\_X@>
raw\_Y
@.raw\_Y@>
raw\_Z
@.raw\_Z@>
raw\_a
@.raw\_a@>
raw\_b
@.raw\_b@>
raw\_c
@.raw\_c@>
raw\_d
@.raw\_d@>
raw\_e
@.raw\_e@>
raw\_f
@.raw\_f@>
raw\_g
@.raw\_g@>
raw\_h
@.raw\_h@>
raw\_i
@.raw\_i@>
raw\_j
@.raw\_j@>
raw\_k
@.raw\_k@>
raw\_l
@.raw\_l@>
raw\_m
@.raw\_m@>
raw\_n
@.raw\_n@>
raw\_o
@.raw\_o@>
raw\_p
@.raw\_p@>
raw\_q
@.raw\_q@>
raw\_r
@.raw\_r@>
raw\_s
@.raw\_s@>
raw\_t
@.raw\_t@>
raw\_u
@.raw\_u@>
raw\_v
@.raw\_v@>
raw\_w
@.raw\_w@>
raw\_x
@.raw\_x@>
raw\_y
@.raw\_y@>
raw\_z
@.raw\_z@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_int\_no --- Integer number lexer.
\Linkeridxentryk{Integer number lexer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_int\_no}{1}
@.TH\_int\_no@>
{\parindent=6pc
\item{First set:}
raw\_0
@.raw\_0@>
raw\_1
@.raw\_1@>
raw\_2
@.raw\_2@>
raw\_3
@.raw\_3@>
raw\_4
@.raw\_4@>
raw\_5
@.raw\_5@>
raw\_6
@.raw\_6@>
raw\_7
@.raw\_7@>
raw\_8
@.raw\_8@>
raw\_9
@.raw\_9@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_la\_express\_source --- Lexer: 1st stage of Lookahead source expression$\ldots$ .
\Linkeridxentryk{Lexer: 1st stage of Lookahead source expression
 converted into raw character tokens for post evaluation.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_la\_express\_source}{1}
@.TH\_la\_express\_source@>
\Linkercalledthreads{TH\_c\_string}{2}
@.TH\_c\_string@>
\Linkercalledthreads{TH\_c\_literal}{2}
@.TH\_c\_literal@>
\Linkercalledthreads{TH\_o2\_code\_end}{2}
@.TH\_o2\_code\_end@>
\Linkercalledthreads{TH\_identifier}{2}
@.TH\_identifier@>
\Linkercalledthreads{TH\_la\_lrk\_T}{2}
@.TH\_la\_lrk\_T@>
\Linkercalledthreads{TH\_lint\_balls}{2}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{3}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_eolr
@.LR1\_eolr@>
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
LR1\_fset\_transience\_operator
@.LR1\_fset\_transience\_operator@>
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_dbl\_quote
@.raw\_dbl\_quote@>
raw\_right\_quote
@.raw\_right\_quote@>
raw\_asteric
@.raw\_asteric@>
raw\_plus
@.raw\_plus@>
raw\_minus
@.raw\_minus@>
raw\_slash
@.raw\_slash@>
raw\_A
@.raw\_A@>
raw\_B
@.raw\_B@>
raw\_C
@.raw\_C@>
raw\_D
@.raw\_D@>
raw\_E
@.raw\_E@>
raw\_F
@.raw\_F@>
raw\_G
@.raw\_G@>
raw\_H
@.raw\_H@>
raw\_I
@.raw\_I@>
raw\_J
@.raw\_J@>
raw\_K
@.raw\_K@>
raw\_L
@.raw\_L@>
raw\_M
@.raw\_M@>
raw\_N
@.raw\_N@>
raw\_O
@.raw\_O@>
raw\_P
@.raw\_P@>
raw\_Q
@.raw\_Q@>
raw\_R
@.raw\_R@>
raw\_S
@.raw\_S@>
raw\_T
@.raw\_T@>
raw\_U
@.raw\_U@>
raw\_V
@.raw\_V@>
raw\_W
@.raw\_W@>
raw\_X
@.raw\_X@>
raw\_Y
@.raw\_Y@>
raw\_Z
@.raw\_Z@>
raw\_a
@.raw\_a@>
raw\_b
@.raw\_b@>
raw\_c
@.raw\_c@>
raw\_d
@.raw\_d@>
raw\_e
@.raw\_e@>
raw\_f
@.raw\_f@>
raw\_g
@.raw\_g@>
raw\_h
@.raw\_h@>
raw\_i
@.raw\_i@>
raw\_j
@.raw\_j@>
raw\_k
@.raw\_k@>
raw\_l
@.raw\_l@>
raw\_m
@.raw\_m@>
raw\_n
@.raw\_n@>
raw\_o
@.raw\_o@>
raw\_p
@.raw\_p@>
raw\_q
@.raw\_q@>
raw\_r
@.raw\_r@>
raw\_s
@.raw\_s@>
raw\_t
@.raw\_t@>
raw\_u
@.raw\_u@>
raw\_v
@.raw\_v@>
raw\_w
@.raw\_w@>
raw\_x
@.raw\_x@>
raw\_y
@.raw\_y@>
raw\_z
@.raw\_z@>
raw\_vertical\_line
@.raw\_vertical\_line@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_literal
@.TH\_c\_literal@>
TH\_c\_string
@.TH\_c\_string@>
TH\_identifier
@.TH\_identifier@>
TH\_la\_lrk\_T
@.TH\_la\_lrk\_T@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_code\_end
@.TH\_o2\_code\_end@>
}
@*2 TH\_la\_lrk\_T --- Unquoted lookahead source symbol recognizer.
\Linkeridxentryk{Unquoted lookahead source symbol recognizer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_la\_lrk\_T}{1}
@.TH\_la\_lrk\_T@>
{\parindent=6pc
\item{First set:}
raw\_dbl\_quote
@.raw\_dbl\_quote@>
raw\_right\_quote
@.raw\_right\_quote@>
raw\_vertical\_line
@.raw\_vertical\_line@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_linker\_id --- \olinker identifiers recognizer: uses symbol table.
\Linkeridxentryk{\olinker identifiers recognizer: uses symbol table.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_linker\_id}{1}
@.TH\_linker\_id@>
{\parindent=6pc
\item{First set:}
raw\_A
@.raw\_A@>
raw\_B
@.raw\_B@>
raw\_C
@.raw\_C@>
raw\_D
@.raw\_D@>
raw\_E
@.raw\_E@>
raw\_F
@.raw\_F@>
raw\_G
@.raw\_G@>
raw\_H
@.raw\_H@>
raw\_I
@.raw\_I@>
raw\_J
@.raw\_J@>
raw\_K
@.raw\_K@>
raw\_L
@.raw\_L@>
raw\_M
@.raw\_M@>
raw\_N
@.raw\_N@>
raw\_O
@.raw\_O@>
raw\_P
@.raw\_P@>
raw\_Q
@.raw\_Q@>
raw\_R
@.raw\_R@>
raw\_S
@.raw\_S@>
raw\_T
@.raw\_T@>
raw\_U
@.raw\_U@>
raw\_V
@.raw\_V@>
raw\_W
@.raw\_W@>
raw\_X
@.raw\_X@>
raw\_Y
@.raw\_Y@>
raw\_Z
@.raw\_Z@>
raw\_a
@.raw\_a@>
raw\_b
@.raw\_b@>
raw\_c
@.raw\_c@>
raw\_d
@.raw\_d@>
raw\_e
@.raw\_e@>
raw\_f
@.raw\_f@>
raw\_g
@.raw\_g@>
raw\_h
@.raw\_h@>
raw\_i
@.raw\_i@>
raw\_j
@.raw\_j@>
raw\_k
@.raw\_k@>
raw\_l
@.raw\_l@>
raw\_m
@.raw\_m@>
raw\_n
@.raw\_n@>
raw\_o
@.raw\_o@>
raw\_p
@.raw\_p@>
raw\_q
@.raw\_q@>
raw\_r
@.raw\_r@>
raw\_s
@.raw\_s@>
raw\_t
@.raw\_t@>
raw\_u
@.raw\_u@>
raw\_v
@.raw\_v@>
raw\_w
@.raw\_w@>
raw\_x
@.raw\_x@>
raw\_y
@.raw\_y@>
raw\_z
@.raw\_z@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_linker\_preamble\_code --- \olinker's lexer of preamble code section:
 $\ldots$ .
\Linkeridxentryk{\olinker's lexer of preamble code section:
 similar to Pass3 lexer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_linker\_preamble\_code}{1}
@.TH\_linker\_preamble\_code@>
\Linkercalledthreads{TH\_c\_comments}{2}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_c\_string}{2}
@.TH\_c\_string@>
\Linkercalledthreads{TH\_c\_literal}{2}
@.TH\_c\_literal@>
\Linkercalledthreads{TH\_linker\_id}{2}
@.TH\_linker\_id@>
{\parindent=6pc
\item{First set:}
LR1\_eolr
@.LR1\_eolr@>
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
raw\_dbl\_quote
@.raw\_dbl\_quote@>
raw\_right\_quote
@.raw\_right\_quote@>
raw\_slash
@.raw\_slash@>
raw\_A
@.raw\_A@>
raw\_B
@.raw\_B@>
raw\_C
@.raw\_C@>
raw\_D
@.raw\_D@>
raw\_E
@.raw\_E@>
raw\_F
@.raw\_F@>
raw\_G
@.raw\_G@>
raw\_H
@.raw\_H@>
raw\_I
@.raw\_I@>
raw\_J
@.raw\_J@>
raw\_K
@.raw\_K@>
raw\_L
@.raw\_L@>
raw\_M
@.raw\_M@>
raw\_N
@.raw\_N@>
raw\_O
@.raw\_O@>
raw\_P
@.raw\_P@>
raw\_Q
@.raw\_Q@>
raw\_R
@.raw\_R@>
raw\_S
@.raw\_S@>
raw\_T
@.raw\_T@>
raw\_U
@.raw\_U@>
raw\_V
@.raw\_V@>
raw\_W
@.raw\_W@>
raw\_X
@.raw\_X@>
raw\_Y
@.raw\_Y@>
raw\_Z
@.raw\_Z@>
raw\_a
@.raw\_a@>
raw\_b
@.raw\_b@>
raw\_c
@.raw\_c@>
raw\_d
@.raw\_d@>
raw\_e
@.raw\_e@>
raw\_f
@.raw\_f@>
raw\_g
@.raw\_g@>
raw\_h
@.raw\_h@>
raw\_i
@.raw\_i@>
raw\_j
@.raw\_j@>
raw\_k
@.raw\_k@>
raw\_l
@.raw\_l@>
raw\_m
@.raw\_m@>
raw\_n
@.raw\_n@>
raw\_o
@.raw\_o@>
raw\_p
@.raw\_p@>
raw\_q
@.raw\_q@>
raw\_r
@.raw\_r@>
raw\_s
@.raw\_s@>
raw\_t
@.raw\_t@>
raw\_u
@.raw\_u@>
raw\_v
@.raw\_v@>
raw\_w
@.raw\_w@>
raw\_x
@.raw\_x@>
raw\_y
@.raw\_y@>
raw\_z
@.raw\_z@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_comments
@.TH\_c\_comments@>
TH\_c\_literal
@.TH\_c\_literal@>
TH\_c\_string
@.TH\_c\_string@>
TH\_linker\_id
@.TH\_linker\_id@>
}
@*2 TH\_lint\_balls --- Is this spring cleaning?.
\Linkeridxentryk{Is this spring cleaning?}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_lint\_balls}{1}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{2}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{2}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{2}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_comments
@.TH\_c\_comments@>
TH\_eol
@.TH\_eol@>
TH\_ws
@.TH\_ws@>
}
@*2 TH\_lr1\_k\_phrase\_th --- Parse lr1 k symbols phrase.
\Linkeridxentryk{Parse lr1 k symbols phrase.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_lr1\_k\_phrase\_th}{1}
@.TH\_lr1\_k\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{2}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{3}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_open\_bracket
@.raw\_open\_bracket@>
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_sdc
@.TH\_o2\_sdc@>
TH\_term\_def\_ph
@.TH\_term\_def\_ph@>
}
@*2 TH\_o2\_code\_end --- Lexer syntax directed code end marker: \threeasteric.
\Linkeridxentryk{Lexer syntax directed code end marker: \threeasteric.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_o2\_code\_end}{1}
@.TH\_o2\_code\_end@>
{\parindent=6pc
\item{First set:}
raw\_asteric
@.raw\_asteric@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_o2\_lcl\_opt --- \O2's individual command line option recognizer.
\Linkeridxentryk{\O2's individual command line option recognizer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_o2\_lcl\_opt}{1}
@.TH\_o2\_lcl\_opt@>
{\parindent=6pc
\item{First set:}
raw\_minus
@.raw\_minus@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_o2\_sdc --- \O2's syntax directed code extractor.
\Linkeridxentryk{\O2's syntax directed code extractor.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_o2\_sdc}{1}
@.TH\_o2\_sdc@>
\Linkercalledthreads{TH\_c\_comments}{2}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_c\_string}{2}
@.TH\_c\_string@>
\Linkercalledthreads{TH\_c\_literal}{2}
@.TH\_c\_literal@>
\Linkercalledthreads{TH\_o2\_code\_end}{2}
@.TH\_o2\_code\_end@>
{\parindent=6pc
\item{First set:}
LR1\_eolr
@.LR1\_eolr@>
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
raw\_dbl\_quote
@.raw\_dbl\_quote@>
raw\_right\_quote
@.raw\_right\_quote@>
raw\_asteric
@.raw\_asteric@>
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_comments
@.TH\_c\_comments@>
TH\_c\_literal
@.TH\_c\_literal@>
TH\_c\_string
@.TH\_c\_string@>
TH\_o2\_code\_end
@.TH\_o2\_code\_end@>
}
@*2 TH\_parallel\_monitor\_ph --- Parse a rule's arbitration code: 
 into the v$\ldots$ .
\Linkeridxentryk{Parse a rule's arbitration code: 
 into the valley of someone's dementia...}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_parallel\_monitor\_ph}{1}
@.TH\_parallel\_monitor\_ph@>
{\parindent=6pc
\item{First set:}
T\_parallel\_control\_monitor
@.T\_parallel\_control\_monitor@>
{\parindent=6pc
\item{Used threads:}
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_sdc
@.TH\_o2\_sdc@>
}
@*2 TH\_parallel\_oper --- Lexer for Parallel operator: \PARshift.
\Linkeridxentryk{Lexer for Parallel operator: \PARshift.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_parallel\_oper}{1}
@.TH\_parallel\_oper@>
{\parindent=6pc
\item{First set:}
raw\_dbl\_quote
@.raw\_dbl\_quote@>
raw\_vertical\_line
@.raw\_vertical\_line@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_parallel\_parser\_ph\_th --- Parse grammar's parallel-parser construct.
\Linkeridxentryk{Parse grammar's parallel-parser construct.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_parallel\_parser\_ph\_th}{1}
@.TH\_parallel\_parser\_ph\_th@>
\Linkercalledthreads{TH\_lint\_balls}{2}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{3}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_open\_bracket
@.raw\_open\_bracket@>
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
TH\_identifier
@.TH\_identifier@>
TH\_la\_express\_source
@.TH\_la\_express\_source@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_code\_end
@.TH\_o2\_code\_end@>
}
@*2 TH\_prefile\_include --- Preprocessor source file from the ``include file''$\ldots$ .
\Linkeridxentryk{Preprocessor source file from the ``include file'' directive.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_prefile\_include}{1}
@.TH\_prefile\_include@>
{\parindent=6pc
\item{First set:}
raw\_at\_sign
@.raw\_at\_sign@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_string
@.TH\_c\_string@>
TH\_eol
@.TH\_eol@>
TH\_ws
@.TH\_ws@>
}
@*2 TH\_rc\_phrase\_th --- Raw character vocabulary parser.
\Linkeridxentryk{Raw character vocabulary parser.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_rc\_phrase\_th}{1}
@.TH\_rc\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{2}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{3}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_open\_bracket
@.raw\_open\_bracket@>
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_term\_def\_ph
@.TH\_term\_def\_ph@>
}
@*2 TH\_rhs\_bnd --- Determine end-of-subrule expression within a rule.
\Linkeridxentryk{Determine end-of-subrule expression within a rule.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_rhs\_bnd}{1}
@.TH\_rhs\_bnd@>
{\parindent=6pc
\item{First set:}
LR1\_eog
@.LR1\_eog@>
raw\_minus
@.raw\_minus@>
raw\_open\_brace
@.raw\_open\_brace@>
raw\_close\_brace
@.raw\_close\_brace@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_rhs\_component --- Subule's individual component recognizer except eosu$\ldots$ .
\Linkeridxentryk{Subule's individual component recognizer except eosubrule.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_rhs\_component}{1}
@.TH\_rhs\_component@>
\Linkercalledthreads{TH\_identifier}{2}
@.TH\_identifier@>
\Linkercalledthreads{TH\_c\_string}{2}
@.TH\_c\_string@>
\Linkercalledthreads{TH\_unq\_str}{2}
@.TH\_unq\_str@>
\Linkercalledthreads{TH\_cweb\_or\_c\_k}{2}
@.TH\_cweb\_or\_c\_k@>
{\parindent=6pc
\item{First set:}
LR1\_eolr
@.LR1\_eolr@>
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
raw\_dbl\_quote
@.raw\_dbl\_quote@>
raw\_slash
@.raw\_slash@>
raw\_A
@.raw\_A@>
raw\_B
@.raw\_B@>
raw\_C
@.raw\_C@>
raw\_D
@.raw\_D@>
raw\_E
@.raw\_E@>
raw\_F
@.raw\_F@>
raw\_G
@.raw\_G@>
raw\_H
@.raw\_H@>
raw\_I
@.raw\_I@>
raw\_J
@.raw\_J@>
raw\_K
@.raw\_K@>
raw\_L
@.raw\_L@>
raw\_M
@.raw\_M@>
raw\_N
@.raw\_N@>
raw\_O
@.raw\_O@>
raw\_P
@.raw\_P@>
raw\_Q
@.raw\_Q@>
raw\_R
@.raw\_R@>
raw\_S
@.raw\_S@>
raw\_T
@.raw\_T@>
raw\_U
@.raw\_U@>
raw\_V
@.raw\_V@>
raw\_W
@.raw\_W@>
raw\_X
@.raw\_X@>
raw\_Y
@.raw\_Y@>
raw\_Z
@.raw\_Z@>
raw\_a
@.raw\_a@>
raw\_b
@.raw\_b@>
raw\_c
@.raw\_c@>
raw\_d
@.raw\_d@>
raw\_e
@.raw\_e@>
raw\_f
@.raw\_f@>
raw\_g
@.raw\_g@>
raw\_h
@.raw\_h@>
raw\_i
@.raw\_i@>
raw\_j
@.raw\_j@>
raw\_k
@.raw\_k@>
raw\_l
@.raw\_l@>
raw\_m
@.raw\_m@>
raw\_n
@.raw\_n@>
raw\_o
@.raw\_o@>
raw\_p
@.raw\_p@>
raw\_q
@.raw\_q@>
raw\_r
@.raw\_r@>
raw\_s
@.raw\_s@>
raw\_t
@.raw\_t@>
raw\_u
@.raw\_u@>
raw\_v
@.raw\_v@>
raw\_w
@.raw\_w@>
raw\_x
@.raw\_x@>
raw\_y
@.raw\_y@>
raw\_z
@.raw\_z@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_string
@.TH\_c\_string@>
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_identifier
@.TH\_identifier@>
TH\_unq\_str
@.TH\_unq\_str@>
}
@*2 TH\_rtn\_component --- Recognizer of returned T from a thread call expressi$\ldots$ .
\Linkeridxentryk{Recognizer of returned T from a thread call expression.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_rtn\_component}{1}
@.TH\_rtn\_component@>
\Linkercalledthreads{TH\_identifier}{2}
@.TH\_identifier@>
\Linkercalledthreads{TH\_c\_string}{2}
@.TH\_c\_string@>
\Linkercalledthreads{TH\_unq\_str}{2}
@.TH\_unq\_str@>
{\parindent=6pc
\item{First set:}
LR1\_eolr
@.LR1\_eolr@>
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
raw\_dbl\_quote
@.raw\_dbl\_quote@>
raw\_A
@.raw\_A@>
raw\_B
@.raw\_B@>
raw\_C
@.raw\_C@>
raw\_D
@.raw\_D@>
raw\_E
@.raw\_E@>
raw\_F
@.raw\_F@>
raw\_G
@.raw\_G@>
raw\_H
@.raw\_H@>
raw\_I
@.raw\_I@>
raw\_J
@.raw\_J@>
raw\_K
@.raw\_K@>
raw\_L
@.raw\_L@>
raw\_M
@.raw\_M@>
raw\_N
@.raw\_N@>
raw\_O
@.raw\_O@>
raw\_P
@.raw\_P@>
raw\_Q
@.raw\_Q@>
raw\_R
@.raw\_R@>
raw\_S
@.raw\_S@>
raw\_T
@.raw\_T@>
raw\_U
@.raw\_U@>
raw\_V
@.raw\_V@>
raw\_W
@.raw\_W@>
raw\_X
@.raw\_X@>
raw\_Y
@.raw\_Y@>
raw\_Z
@.raw\_Z@>
raw\_a
@.raw\_a@>
raw\_b
@.raw\_b@>
raw\_c
@.raw\_c@>
raw\_d
@.raw\_d@>
raw\_e
@.raw\_e@>
raw\_f
@.raw\_f@>
raw\_g
@.raw\_g@>
raw\_h
@.raw\_h@>
raw\_i
@.raw\_i@>
raw\_j
@.raw\_j@>
raw\_k
@.raw\_k@>
raw\_l
@.raw\_l@>
raw\_m
@.raw\_m@>
raw\_n
@.raw\_n@>
raw\_o
@.raw\_o@>
raw\_p
@.raw\_p@>
raw\_q
@.raw\_q@>
raw\_r
@.raw\_r@>
raw\_s
@.raw\_s@>
raw\_t
@.raw\_t@>
raw\_u
@.raw\_u@>
raw\_v
@.raw\_v@>
raw\_w
@.raw\_w@>
raw\_x
@.raw\_x@>
raw\_y
@.raw\_y@>
raw\_z
@.raw\_z@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_string
@.TH\_c\_string@>
TH\_identifier
@.TH\_identifier@>
TH\_unq\_str
@.TH\_unq\_str@>
}
@*2 TH\_rules\_phrase\_th --- Parse all of the grammar's rules.
\Linkeridxentryk{Parse all of the grammar's rules.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_rules\_phrase\_th}{1}
@.TH\_rules\_phrase\_th@>
\Linkercalledthreads{TH\_ws}{2}
@.TH\_ws@>
\Linkercalledthreads{TH\_cweb\_or\_c\_k}{2}
@.TH\_cweb\_or\_c\_k@>
\Linkercalledthreads{TH\_eol}{2}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_slash
@.raw\_slash@>
raw\_open\_brace
@.raw\_open\_brace@>
{\parindent=6pc
\item{Used threads:}
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_eol
@.TH\_eol@>
TH\_rule\_def\_phrase
@.TH\_rule\_def\_phrase@>
TH\_ws
@.TH\_ws@>
}
@*2 TH\_rule\_def\_phrase --- Parse a grammar's rule  definition.
\Linkeridxentryk{Parse a grammar's rule  definition.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_rule\_def\_phrase}{1}
@.TH\_rule\_def\_phrase@>
\Linkercalledthreads{TH\_identifier}{2}
@.TH\_identifier@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_A
@.raw\_A@>
raw\_B
@.raw\_B@>
raw\_C
@.raw\_C@>
raw\_D
@.raw\_D@>
raw\_E
@.raw\_E@>
raw\_F
@.raw\_F@>
raw\_G
@.raw\_G@>
raw\_H
@.raw\_H@>
raw\_I
@.raw\_I@>
raw\_J
@.raw\_J@>
raw\_K
@.raw\_K@>
raw\_L
@.raw\_L@>
raw\_M
@.raw\_M@>
raw\_N
@.raw\_N@>
raw\_O
@.raw\_O@>
raw\_P
@.raw\_P@>
raw\_Q
@.raw\_Q@>
raw\_R
@.raw\_R@>
raw\_S
@.raw\_S@>
raw\_T
@.raw\_T@>
raw\_U
@.raw\_U@>
raw\_V
@.raw\_V@>
raw\_W
@.raw\_W@>
raw\_X
@.raw\_X@>
raw\_Y
@.raw\_Y@>
raw\_Z
@.raw\_Z@>
raw\_a
@.raw\_a@>
raw\_b
@.raw\_b@>
raw\_c
@.raw\_c@>
raw\_d
@.raw\_d@>
raw\_e
@.raw\_e@>
raw\_f
@.raw\_f@>
raw\_g
@.raw\_g@>
raw\_h
@.raw\_h@>
raw\_i
@.raw\_i@>
raw\_j
@.raw\_j@>
raw\_k
@.raw\_k@>
raw\_l
@.raw\_l@>
raw\_m
@.raw\_m@>
raw\_n
@.raw\_n@>
raw\_o
@.raw\_o@>
raw\_p
@.raw\_p@>
raw\_q
@.raw\_q@>
raw\_r
@.raw\_r@>
raw\_s
@.raw\_s@>
raw\_t
@.raw\_t@>
raw\_u
@.raw\_u@>
raw\_v
@.raw\_v@>
raw\_w
@.raw\_w@>
raw\_x
@.raw\_x@>
raw\_y
@.raw\_y@>
raw\_z
@.raw\_z@>
{\parindent=6pc
\item{Used threads:}
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_subrules\_phrase
@.TH\_subrules\_phrase@>
TH\_t\_def\_delabort\_tags
@.TH\_t\_def\_delabort\_tags@>
}
@*2 TH\_rule\_lhs\_phrase --- Parse a rule's ``lhs'' directive.
\Linkeridxentryk{Parse a rule's ``lhs'' directive.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_rule\_lhs\_phrase}{1}
@.TH\_rule\_lhs\_phrase@>
{\parindent=6pc
\item{First set:}
T\_lhs
@.T\_lhs@>
{\parindent=6pc
\item{Used threads:}
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_sdc
@.TH\_o2\_sdc@>
}
@*2 TH\_subrules\_phrase --- Parse subrules: into the valley of ...
\Linkeridxentryk{Parse subrules: into the valley of ...}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_subrules\_phrase}{1}
@.TH\_subrules\_phrase@>
\Linkercalledthreads{TH\_subrule\_def}{2}
@.TH\_subrule\_def@>
\Linkercalledthreads{TH\_subrule\_vector}{3}
@.TH\_subrule\_vector@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_minus
@.raw\_minus@>
{\parindent=6pc
\item{Used threads:}
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_subrule\_def
@.TH\_subrule\_def@>
}
@*2 TH\_subrule\_def --- Parse a subrule: into the valley of sin...
\Linkeridxentryk{Parse a subrule: into the valley of sin...}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_subrule\_def}{1}
@.TH\_subrule\_def@>
\Linkercalledthreads{TH\_subrule\_vector}{2}
@.TH\_subrule\_vector@>
{\parindent=6pc
\item{First set:}
raw\_minus
@.raw\_minus@>
{\parindent=6pc
\item{Used threads:}
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_dbl\_colon
@.TH\_dbl\_colon@>
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_sdc
@.TH\_o2\_sdc@>
TH\_parallel\_oper
@.TH\_parallel\_oper@>
TH\_rhs\_bnd
@.TH\_rhs\_bnd@>
TH\_rhs\_component
@.TH\_rhs\_component@>
TH\_rtn\_component
@.TH\_rtn\_component@>
TH\_subrule\_vector
@.TH\_subrule\_vector@>
}
@*2 TH\_subrule\_vector --- Lexer of subrule begin operator: \subrule.
\Linkeridxentryk{Lexer of subrule begin operator: \subrule.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_subrule\_vector}{1}
@.TH\_subrule\_vector@>
{\parindent=6pc
\item{First set:}
raw\_minus
@.raw\_minus@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_terminals\_phrase\_th --- Parse terminals vocabulary.
\Linkeridxentryk{Parse terminals vocabulary.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_terminals\_phrase\_th}{1}
@.TH\_terminals\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{2}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{3}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_open\_bracket
@.raw\_open\_bracket@>
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_sdc
@.TH\_o2\_sdc@>
TH\_term\_def\_ph
@.TH\_term\_def\_ph@>
}
@*2 TH\_terminal\_def\_symclass --- Lexer of ``sym-class'' keyword.
\Linkeridxentryk{Lexer of ``sym-class'' keyword.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_terminal\_def\_symclass}{1}
@.TH\_terminal\_def\_symclass@>
{\parindent=6pc
\item{First set:}
raw\_s
@.raw\_s@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_term\_def\_ph --- Parse a terminal symbol.
\Linkeridxentryk{Parse a terminal symbol.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_term\_def\_ph}{1}
@.TH\_term\_def\_ph@>
\Linkercalledthreads{TH\_c\_string}{2}
@.TH\_c\_string@>
\Linkercalledthreads{TH\_identifier}{2}
@.TH\_identifier@>
{\parindent=6pc
\item{First set:}
raw\_dbl\_quote
@.raw\_dbl\_quote@>
raw\_A
@.raw\_A@>
raw\_B
@.raw\_B@>
raw\_C
@.raw\_C@>
raw\_D
@.raw\_D@>
raw\_E
@.raw\_E@>
raw\_F
@.raw\_F@>
raw\_G
@.raw\_G@>
raw\_H
@.raw\_H@>
raw\_I
@.raw\_I@>
raw\_J
@.raw\_J@>
raw\_K
@.raw\_K@>
raw\_L
@.raw\_L@>
raw\_M
@.raw\_M@>
raw\_N
@.raw\_N@>
raw\_O
@.raw\_O@>
raw\_P
@.raw\_P@>
raw\_Q
@.raw\_Q@>
raw\_R
@.raw\_R@>
raw\_S
@.raw\_S@>
raw\_T
@.raw\_T@>
raw\_U
@.raw\_U@>
raw\_V
@.raw\_V@>
raw\_W
@.raw\_W@>
raw\_X
@.raw\_X@>
raw\_Y
@.raw\_Y@>
raw\_Z
@.raw\_Z@>
raw\_a
@.raw\_a@>
raw\_b
@.raw\_b@>
raw\_c
@.raw\_c@>
raw\_d
@.raw\_d@>
raw\_e
@.raw\_e@>
raw\_f
@.raw\_f@>
raw\_g
@.raw\_g@>
raw\_h
@.raw\_h@>
raw\_i
@.raw\_i@>
raw\_j
@.raw\_j@>
raw\_k
@.raw\_k@>
raw\_l
@.raw\_l@>
raw\_m
@.raw\_m@>
raw\_n
@.raw\_n@>
raw\_o
@.raw\_o@>
raw\_p
@.raw\_p@>
raw\_q
@.raw\_q@>
raw\_r
@.raw\_r@>
raw\_s
@.raw\_s@>
raw\_t
@.raw\_t@>
raw\_u
@.raw\_u@>
raw\_v
@.raw\_v@>
raw\_w
@.raw\_w@>
raw\_x
@.raw\_x@>
raw\_y
@.raw\_y@>
raw\_z
@.raw\_z@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_string
@.TH\_c\_string@>
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_sdc
@.TH\_o2\_sdc@>
TH\_t\_def\_delabort\_tags
@.TH\_t\_def\_delabort\_tags@>
TH\_terminal\_def\_symclass
@.TH\_terminal\_def\_symclass@>
}
@*2 TH\_t\_def\_delabort\_tags --- AB AD grammar symbol tags recognizer.
\Linkeridxentryk{AB AD grammar symbol tags recognizer.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_t\_def\_delabort\_tags}{1}
@.TH\_t\_def\_delabort\_tags@>
{\parindent=6pc
\item{First set:}
raw\_A
@.raw\_A@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_T\_enum\_phrase\_th --- Parse ``T-enumeration'' construct: Time out sme$\ldots$ .
\Linkeridxentryk{Parse ``T-enumeration'' construct: Time out smell the tullips.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_T\_enum\_phrase\_th}{1}
@.TH\_T\_enum\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{2}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{3}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
raw\_ht
@.raw\_ht@>
raw\_lf
@.raw\_lf@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_cr
@.raw\_cr@>
raw\_sp
@.raw\_sp@>
raw\_open\_bracket
@.raw\_open\_bracket@>
raw\_slash
@.raw\_slash@>
{\parindent=6pc
\item{Used threads:}
TH\_identifier
@.TH\_identifier@>
TH\_lint\_balls
@.TH\_lint\_balls@>
TH\_o2\_sdc
@.TH\_o2\_sdc@>
}
@*2 TH\_unq\_str --- Unquoted string of characters: raw and basic.
\Linkeridxentryk{Unquoted string of characters: raw and basic.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_unq\_str}{1}
@.TH\_unq\_str@>
{\parindent=6pc
\item{First set:}
LR1\_eolr
@.LR1\_eolr@>
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_ws --- White space globber.
\Linkeridxentryk{White space globber.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_ws}{1}
@.TH\_ws@>
{\parindent=6pc
\item{First set:}
raw\_ht
@.raw\_ht@>
raw\_vt
@.raw\_vt@>
raw\_ff
@.raw\_ff@>
raw\_sp
@.raw\_sp@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 TH\_xc\_str --- No escape sequence check: accept all characters between dbl$\ldots$ .
\Linkeridxentryk{No escape sequence check: accept all characters between dbl. quoted string.}
\Linkercalledthreadstitle
\Linkercalledthreads{TH\_xc\_str}{1}
@.TH\_xc\_str@>
{\parindent=6pc
\item{First set:}
raw\_dbl\_quote
@.raw\_dbl\_quote@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Ccweave\_fsm\_sdc --- Write out cweave fsm directives sentences.
\Linkeridxentryk{Write out cweave fsm directives sentences.}
\Linkercalledthreadstitle
\Linkercalledthreads{Ccweave\_fsm\_sdc}{1}
@.Ccweave\_fsm\_sdc@>
{\parindent=6pc
\item{First set:}
T\_user\_declaration
@.T\_user\_declaration@>
T\_user\_prefix\_declaration
@.T\_user\_prefix\_declaration@>
T\_user\_suffix\_declaration
@.T\_user\_suffix\_declaration@>
T\_constructor
@.T\_constructor@>
T\_destructor
@.T\_destructor@>
T\_op
@.T\_op@>
T\_failed
@.T\_failed@>
T\_user\_implementation
@.T\_user\_implementation@>
T\_user\_imp\_tbl
@.T\_user\_imp\_tbl@>
T\_user\_imp\_sym
@.T\_user\_imp\_sym@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Ccweave\_lhs\_sdc --- Write out cweave rule's lhs directives sentences.
\Linkeridxentryk{Write out cweave rule's lhs directives sentences}
\Linkercalledthreadstitle
\Linkercalledthreads{Ccweave\_lhs\_sdc}{1}
@.Ccweave\_lhs\_sdc@>
{\parindent=6pc
\item{First set:}
T\_arbitrator\_code
@.T\_arbitrator\_code@>
T\_user\_declaration
@.T\_user\_declaration@>
T\_constructor
@.T\_constructor@>
T\_destructor
@.T\_destructor@>
T\_op
@.T\_op@>
T\_user\_implementation
@.T\_user\_implementation@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Ccweave\_sdc --- Write out cweave subrule's sdc irectives sentences.
\Linkeridxentryk{Write out cweave subrule's sdc irectives sentences}
\Linkercalledthreadstitle
\Linkercalledthreads{Ccweave\_sdc}{1}
@.Ccweave\_sdc@>
{\parindent=6pc
\item{First set:}
T\_arbitrator\_code
@.T\_arbitrator\_code@>
T\_user\_declaration
@.T\_user\_declaration@>
T\_user\_prefix\_declaration
@.T\_user\_prefix\_declaration@>
T\_user\_suffix\_declaration
@.T\_user\_suffix\_declaration@>
T\_constructor
@.T\_constructor@>
T\_destructor
@.T\_destructor@>
T\_op
@.T\_op@>
T\_user\_implementation
@.T\_user\_implementation@>
T\_user\_imp\_tbl
@.T\_user\_imp\_tbl@>
T\_user\_imp\_sym
@.T\_user\_imp\_sym@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Ccweave\_T\_sdc --- Write out cweave Terminals' sdc directives.
\Linkeridxentryk{Write out cweave Terminals' sdc directives.}
\Linkercalledthreadstitle
\Linkercalledthreads{Ccweave\_T\_sdc}{1}
@.Ccweave\_T\_sdc@>
{\parindent=6pc
\item{First set:}
T\_user\_declaration
@.T\_user\_declaration@>
T\_constructor
@.T\_constructor@>
T\_destructor
@.T\_destructor@>
T\_op
@.T\_op@>
T\_user\_implementation
@.T\_user\_implementation@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Ccweb\_put\_k\_into\_ph --- Extract CWEB comments.
\Linkeridxentryk{Extract CWEB comments.}
\Linkercalledthreadstitle
\Linkercalledthreads{Ccweb\_put\_k\_into\_ph}{1}
@.Ccweb\_put\_k\_into\_ph@>
{\parindent=6pc
\item{First set:}
T\_fsm\_phrase
@.T\_fsm\_phrase@>
T\_parallel\_parser\_phrase
@.T\_parallel\_parser\_phrase@>
T\_enum\_phrase
@.T\_enum\_phrase@>
T\_terminals\_phrase
@.T\_terminals\_phrase@>
T\_error\_symbols\_phrase
@.T\_error\_symbols\_phrase@>
T\_lr1\_k\_phrase
@.T\_lr1\_k\_phrase@>
T\_rc\_phrase
@.T\_rc\_phrase@>
T\_rules\_phrase
@.T\_rules\_phrase@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Cenumerate\_grammar --- Dump aid: Enumerate grammar's components.
\Linkeridxentryk{Dump aid: Enumerate grammar's components}
\Linkercalledthreadstitle
\Linkercalledthreads{Cenumerate\_grammar}{1}
@.Cenumerate\_grammar@>
{\parindent=6pc
\item{First set:}
rule\_def
@.rule\_def@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Cenumerate\_T\_alphabet --- Enumerate grammar's terminal symbols: 
a 0 and $\ldots$ .
\Linkeridxentryk{Enumerate grammar's terminal symbols: 
a 0 and a 1, ... the oracle for parsing lookups.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cenumerate\_T\_alphabet}{1}
@.Cenumerate\_T\_alphabet@>
{\parindent=6pc
\item{First set:}
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Cepsilon\_rules --- Determine whether rules are epsilon, derive T, or are p$\ldots$ .
\Linkeridxentryk{Determine whether rules are epsilon, derive T, or are pathological.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cepsilon\_rules}{1}
@.Cepsilon\_rules@>
{\parindent=6pc
\item{First set:}
rule\_def
@.rule\_def@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Cerr\_symbols\_ph --- Dispatcher to parse ``error-symbols'' vocabulary.
\Linkeridxentryk{Dispatcher to parse ``error-symbols'' vocabulary.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cerr\_symbols\_ph}{1}
@.Cerr\_symbols\_ph@>
\Linkercalledthreads{TH\_err\_symbols\_ph\_th}{2}
@.TH\_err\_symbols\_ph\_th@>
\Linkercalledthreads{TH\_lint\_balls}{3}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{4}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{4}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{4}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_err\_symbols\_ph\_th
@.TH\_err\_symbols\_ph\_th@>
}
@*2 Ceval\_phrases --- Evaluate parse phrase sequencer: 
 as i use a top / down$\ldots$ .
\Linkeridxentryk{Evaluate parse phrase sequencer: 
 as i use a top / down approach to dispatching the various phrases.}
\Linkercalledthreadstitle
\Linkercalledthreads{Ceval\_phrases}{1}
@.Ceval\_phrases@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
LR1\_eog
@.LR1\_eog@>
T\_fsm\_phrase
@.T\_fsm\_phrase@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Cfsc\_file --- \Olinker's ``fsc'' control file parser.
\Linkeridxentryk{\Olinker's ``fsc'' control file parser.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cfsc\_file}{1}
@.Cfsc\_file@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
T\_transitive
@.T\_transitive@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Cfsm\_phrase --- Dispatcher to parse ``fsm'' construct.
\Linkeridxentryk{Dispatcher to parse ``fsm'' construct.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cfsm\_phrase}{1}
@.Cfsm\_phrase@>
\Linkercalledthreads{TH\_fsm\_phrase\_th}{2}
@.TH\_fsm\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{3}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{4}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{4}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{4}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_fsm\_phrase\_th
@.TH\_fsm\_phrase\_th@>
}
@*2 Cla\_expr --- Parse the lookahead expression after chaffe removed.
\Linkeridxentryk{Parse the lookahead expression after chaffe removed.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cla\_expr}{1}
@.Cla\_expr@>
{\parindent=6pc
\item{First set:}
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
T\_in\_stbl
@.T\_in\_stbl@>
rule\_in\_stbl
@.rule\_in\_stbl@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Cla\_expr\_lexical --- Lexer: 2nd stage lexing for lookahead: stripper...
\Linkeridxentryk{Lexer: 2nd stage lexing for lookahead: stripper...}
\Linkercalledthreadstitle
\Linkercalledthreads{Cla\_expr\_lexical}{1}
@.Cla\_expr\_lexical@>
{\parindent=6pc
\item{First set:}
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
raw\_plus
@.raw\_plus@>
raw\_minus
@.raw\_minus@>
T\_c\_literal
@.T\_c\_literal@>
T\_c\_string
@.T\_c\_string@>
T\_identifier
@.T\_identifier@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Clinker\_pass3 --- Lexer: constructing tokens for \olinker parsing stage.
\Linkeridxentryk{Lexer: constructing tokens for \olinker parsing stage.}
\Linkercalledthreadstitle
\Linkercalledthreads{Clinker\_pass3}{1}
@.Clinker\_pass3@>
\Linkercalledthreads{TH\_linker\_id}{2}
@.TH\_linker\_id@>
\Linkercalledthreads{TH\_lint\_balls}{2}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{3}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_angled\_string
@.TH\_angled\_string@>
TH\_c\_string
@.TH\_c\_string@>
TH\_linker\_id
@.TH\_linker\_id@>
TH\_linker\_preamble\_code
@.TH\_linker\_preamble\_code@>
TH\_lint\_balls
@.TH\_lint\_balls@>
}
@*2 Clink\_cleanser --- Lexer: \olinker's cleanser from 
 previous lexing to re$\ldots$ .
\Linkeridxentryk{Lexer: \olinker's cleanser from 
 previous lexing to remove chaffe before parsing stage.}
\Linkercalledthreadstitle
\Linkercalledthreads{Clink\_cleanser}{1}
@.Clink\_cleanser@>
\Linkercalledthreads{TH\_ws}{2}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{2}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_c\_string}{2}
@.TH\_c\_string@>
\Linkercalledthreads{TH\_linker\_id}{2}
@.TH\_linker\_id@>
\Linkercalledthreads{TH\_int\_no}{2}
@.TH\_int\_no@>
\Linkercalledthreads{TH\_eol}{2}
@.TH\_eol@>
\Linkercalledthreads{TH\_bad\_char\_set}{2}
@.TH\_bad\_char\_set@>
{\parindent=6pc
\item{First set:}
LR1\_eog
@.LR1\_eog@>
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_bad\_char\_set
@.TH\_bad\_char\_set@>
TH\_c\_comments
@.TH\_c\_comments@>
TH\_c\_string
@.TH\_c\_string@>
TH\_eol
@.TH\_eol@>
TH\_int\_no
@.TH\_int\_no@>
TH\_linker\_id
@.TH\_linker\_id@>
TH\_ws
@.TH\_ws@>
}
@*2 Clr1\_k\_phrase --- Dispatcher to parse ``lrk-symbols'' construct.
\Linkeridxentryk{Dispatcher to parse ``lrk-symbols'' construct.}
\Linkercalledthreadstitle
\Linkercalledthreads{Clr1\_k\_phrase}{1}
@.Clr1\_k\_phrase@>
\Linkercalledthreads{TH\_lr1\_k\_phrase\_th}{2}
@.TH\_lr1\_k\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{3}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{4}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{4}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{4}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_lr1\_k\_phrase\_th
@.TH\_lr1\_k\_phrase\_th@>
}
@*2 Cmpost\_output --- Output grammar rules railroad diagrams for mpost that cw$\ldots$ .
\Linkeridxentryk{Output grammar rules railroad diagrams for mpost that cweb program uses.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cmpost\_output}{1}
@.Cmpost\_output@>
{\parindent=6pc
\item{First set:}
T\_grammar\_phrase
@.T\_grammar\_phrase@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Co2\_err\_hdlr --- Logic sequencer: Print out errors from \O2.
\Linkeridxentryk{Logic sequencer: Print out errors from \O2.}
\Linkercalledthreadstitle
\Linkercalledthreads{Co2\_err\_hdlr}{1}
@.Co2\_err\_hdlr@>
{\parindent=6pc
\item{First set:}
LR1\_eog
@.LR1\_eog@>
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
Err\_nested\_files\_exceeded
@.Err\_nested\_files\_exceeded@>
Err\_no\_end\_of\_code
@.Err\_no\_end\_of\_code@>
Err\_no\_filename
@.Err\_no\_filename@>
Err\_bad\_filename
@.Err\_bad\_filename@>
Err\_bad\_cmd\_lne\_opt
@.Err\_bad\_cmd\_lne\_opt@>
Err\_bad\_int\_no
@.Err\_bad\_int\_no@>
Err\_bad\_int\_no\_range
@.Err\_bad\_int\_no\_range@>
Err\_no\_int\_present
@.Err\_no\_int\_present@>
Err\_bad\_eos
@.Err\_bad\_eos@>
Err\_bad\_esc
@.Err\_bad\_esc@>
Err\_comment\_overrun
@.Err\_comment\_overrun@>
Err\_bad\_char
@.Err\_bad\_char@>
Err\_bad\_univ\_seq
@.Err\_bad\_univ\_seq@>
T\_file\_inclusion
@.T\_file\_inclusion@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Co2\_lcl\_opts --- \O2's command line options dispatcher.
\Linkeridxentryk{\O2's command line options dispatcher.}
\Linkercalledthreadstitle
\Linkercalledthreads{Co2\_lcl\_opts}{1}
@.Co2\_lcl\_opts@>
\Linkercalledthreads{TH\_ws}{2}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{2}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{2}
@.TH\_eol@>
\Linkercalledthreads{TH\_unq\_str}{2}
@.TH\_unq\_str@>
\Linkercalledthreads{TH\_xc\_str}{2}
@.TH\_xc\_str@>
\Linkercalledthreads{TH\_o2\_lcl\_opt}{2}
@.TH\_o2\_lcl\_opt@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_comments
@.TH\_c\_comments@>
TH\_eol
@.TH\_eol@>
TH\_o2\_lcl\_opt
@.TH\_o2\_lcl\_opt@>
TH\_unq\_str
@.TH\_unq\_str@>
TH\_ws
@.TH\_ws@>
TH\_xc\_str
@.TH\_xc\_str@>
}
@*2 Co2\_linker\_opts --- \Olinker's Command line options parser.
\Linkeridxentryk{\Olinker's Command line options parser.}
\Linkercalledthreadstitle
\Linkercalledthreads{Co2\_linker\_opts}{1}
@.Co2\_linker\_opts@>
\Linkercalledthreads{TH\_ws}{2}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{2}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{2}
@.TH\_eol@>
\Linkercalledthreads{TH\_unq\_str}{2}
@.TH\_unq\_str@>
\Linkercalledthreads{TH\_xc\_str}{2}
@.TH\_xc\_str@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_c\_comments
@.TH\_c\_comments@>
TH\_eol
@.TH\_eol@>
TH\_unq\_str
@.TH\_unq\_str@>
TH\_ws
@.TH\_ws@>
TH\_xc\_str
@.TH\_xc\_str@>
}
@*2 Cparallel\_parser\_phrase --- Dispather to parse grammar's ``parallel-parse$\ldots$ .
\Linkeridxentryk{Dispather to parse grammar's ``parallel-parser'' construct.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cparallel\_parser\_phrase}{1}
@.Cparallel\_parser\_phrase@>
\Linkercalledthreads{TH\_parallel\_parser\_ph\_th}{2}
@.TH\_parallel\_parser\_ph\_th@>
\Linkercalledthreads{TH\_lint\_balls}{3}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{4}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{4}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{4}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_parallel\_parser\_ph\_th
@.TH\_parallel\_parser\_ph\_th@>
}
@*2 Cpass3 --- \O2's lexer constructing tokens for syntax parser stage.
\Linkeridxentryk{\O2's lexer constructing tokens for syntax parser stage.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cpass3}{1}
@.Cpass3@>
\Linkercalledthreads{TH\_ws}{2}
@.TH\_ws@>
\Linkercalledthreads{TH\_identifier}{2}
@.TH\_identifier@>
\Linkercalledthreads{TH\_cweb\_or\_c\_k}{2}
@.TH\_cweb\_or\_c\_k@>
\Linkercalledthreads{TH\_eol}{2}
@.TH\_eol@>
\Linkercalledthreads{TH\_bad\_char\_set}{2}
@.TH\_bad\_char\_set@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
LR1\_eog
@.LR1\_eog@>
raw\_at\_sign
@.raw\_at\_sign@>
{\parindent=6pc
\item{Used threads:}
TH\_bad\_char\_set
@.TH\_bad\_char\_set@>
TH\_cweb\_or\_c\_k
@.TH\_cweb\_or\_c\_k@>
TH\_eol
@.TH\_eol@>
TH\_identifier
@.TH\_identifier@>
TH\_ws
@.TH\_ws@>
}
@*2 Cprt\_sr\_elements --- Print the subrule's symbol string.
\Linkeridxentryk{Print the subrule's symbol string.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cprt\_sr\_elements}{1}
@.Cprt\_sr\_elements@>
{\parindent=6pc
\item{First set:}
T\_subrule\_def
@.T\_subrule\_def@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Cprt\_xrefs\_docs --- Output xref doc --- 
``first set'' per rule, and refe$\ldots$ .
\Linkeridxentryk{Output xref doc --- 
``first set'' per rule, and referenced symbols.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cprt\_xrefs\_docs}{1}
@.Cprt\_xrefs\_docs@>
{\parindent=6pc
\item{First set:}
rule\_def
@.rule\_def@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Crc\_phrase --- Dispatcher to parse raw character vocabulary.
\Linkeridxentryk{Dispatcher to parse raw character vocabulary.}
\Linkercalledthreadstitle
\Linkercalledthreads{Crc\_phrase}{1}
@.Crc\_phrase@>
\Linkercalledthreads{TH\_rc\_phrase\_th}{2}
@.TH\_rc\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{3}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{4}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{4}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{4}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_rc\_phrase\_th
@.TH\_rc\_phrase\_th@>
}
@*2 Crules\_phrase --- Dispatcher to parse the grammar's rules.
\Linkeridxentryk{Dispatcher to parse the grammar's rules.}
\Linkercalledthreadstitle
\Linkercalledthreads{Crules\_phrase}{1}
@.Crules\_phrase@>
\Linkercalledthreads{TH\_rules\_phrase\_th}{2}
@.TH\_rules\_phrase\_th@>
\Linkercalledthreads{TH\_ws}{3}
@.TH\_ws@>
\Linkercalledthreads{TH\_cweb\_or\_c\_k}{3}
@.TH\_cweb\_or\_c\_k@>
\Linkercalledthreads{TH\_eol}{3}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_rules\_phrase\_th
@.TH\_rules\_phrase\_th@>
}
@*2 Crules\_use\_cnt --- Optimization: Count ``rules used'' 
 to lower new / de$\ldots$ .
\Linkeridxentryk{Optimization: Count ``rules used'' 
 to lower new / delete rule cycles while parsing.}
\Linkercalledthreadstitle
\Linkercalledthreads{Crules\_use\_cnt}{1}
@.Crules\_use\_cnt@>
{\parindent=6pc
\item{First set:}
rule\_def
@.rule\_def@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 Cterminals\_phrase --- Dispatcher to parse the terminals alphabet.
\Linkeridxentryk{Dispatcher to parse the terminals alphabet.}
\Linkercalledthreadstitle
\Linkercalledthreads{Cterminals\_phrase}{1}
@.Cterminals\_phrase@>
\Linkercalledthreads{TH\_terminals\_phrase\_th}{2}
@.TH\_terminals\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{3}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{4}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{4}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{4}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_terminals\_phrase\_th
@.TH\_terminals\_phrase\_th@>
}
@*2 Ctest\_components --- Tester: lexical stage constructing tokens for syntax $\ldots$ .
\Linkeridxentryk{Tester: lexical stage constructing tokens for syntax parser.}
\Linkercalledthreadstitle
\Linkercalledthreads{Ctest\_components}{1}
@.Ctest\_components@>
\Linkercalledthreads{TH\_o2\_code\_end}{2}
@.TH\_o2\_code\_end@>
\Linkercalledthreads{TH\_angled\_string}{2}
@.TH\_angled\_string@>
\Linkercalledthreads{TH\_bad\_char\_set}{2}
@.TH\_bad\_char\_set@>
\Linkercalledthreads{TH\_c\_comments}{2}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_c\_literal}{2}
@.TH\_c\_literal@>
\Linkercalledthreads{TH\_c\_string}{2}
@.TH\_c\_string@>
\Linkercalledthreads{TH\_dbl\_colon}{2}
@.TH\_dbl\_colon@>
\Linkercalledthreads{TH\_eol}{2}
@.TH\_eol@>
\Linkercalledthreads{TH\_esc\_seq}{2}
@.TH\_esc\_seq@>
\Linkercalledthreads{TH\_identifier}{2}
@.TH\_identifier@>
\Linkercalledthreads{TH\_int\_no}{2}
@.TH\_int\_no@>
\Linkercalledthreads{TH\_ws}{2}
@.TH\_ws@>
{\parindent=6pc
\item{First set:}
LR1\_eog
@.LR1\_eog@>
LR1\_all\_shift\_operator
@.LR1\_all\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_angled\_string
@.TH\_angled\_string@>
TH\_bad\_char\_set
@.TH\_bad\_char\_set@>
TH\_c\_comments
@.TH\_c\_comments@>
TH\_c\_literal
@.TH\_c\_literal@>
TH\_c\_string
@.TH\_c\_string@>
TH\_dbl\_colon
@.TH\_dbl\_colon@>
TH\_eol
@.TH\_eol@>
TH\_esc\_seq
@.TH\_esc\_seq@>
TH\_identifier
@.TH\_identifier@>
TH\_int\_no
@.TH\_int\_no@>
TH\_o2\_code\_end
@.TH\_o2\_code\_end@>
TH\_ws
@.TH\_ws@>
}
@*2 Ct\_alphabet --- Parse Linker's t-alphabet language.
\Linkeridxentryk{Parse Linker's t-alphabet language.}
\Linkercalledthreadstitle
\Linkercalledthreads{Ct\_alphabet}{1}
@.Ct\_alphabet@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
T\_T\_alphabet
@.T\_T\_alphabet@>
{\parindent=6pc
\item{Used threads:}
 none
}
@*2 CT\_enum\_phrase --- Dispatcher to parse T-enumeration construct.
\Linkeridxentryk{Dispatcher to parse T-enumeration construct.}
\Linkercalledthreadstitle
\Linkercalledthreads{CT\_enum\_phrase}{1}
@.CT\_enum\_phrase@>
\Linkercalledthreads{TH\_T\_enum\_phrase\_th}{2}
@.TH\_T\_enum\_phrase\_th@>
\Linkercalledthreads{TH\_lint\_balls}{3}
@.TH\_lint\_balls@>
\Linkercalledthreads{TH\_ws}{4}
@.TH\_ws@>
\Linkercalledthreads{TH\_c\_comments}{4}
@.TH\_c\_comments@>
\Linkercalledthreads{TH\_eol}{4}
@.TH\_eol@>
{\parindent=6pc
\item{First set:}
LR1\_questionable\_shift\_operator
@.LR1\_questionable\_shift\_operator@>
{\parindent=6pc
\item{Used threads:}
TH\_T\_enum\_phrase\_th
@.TH\_T\_enum\_phrase\_th@>
}
@** First set control file (fsc) listing.\fbreak
File : ``/yacco2/compiler/grammars/yacco2.fsc''\fbreak
\let\setuplistinghook = \relax
\listing{"/yacco2/compiler/grammars/yacco2.fsc"}

@** Index.
